/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler.observability;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.component.ComponentId;
import com.yahoo.component.Vtag;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.Container;
import com.yahoo.container.core.ApplicationMetadataConfig;
import com.yahoo.container.handler.observability.ApplicationUserdataConfig;
import com.yahoo.container.jdisc.JdiscBindingsConfig;
import com.yahoo.docproc.Call;
import com.yahoo.docproc.DocprocService;
import com.yahoo.docproc.jdisc.DocumentProcessingHandler;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.FastContentWriter;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.handler.ResponseDispatch;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.filter.RequestFilterBase;
import com.yahoo.jdisc.http.filter.ResponseFilterBase;
import com.yahoo.jdisc.service.ClientProvider;
import com.yahoo.jdisc.service.ServerProvider;
import com.yahoo.processing.execution.chain.ChainRegistry;
import com.yahoo.processing.handler.ProcessingHandler;
import com.yahoo.search.handler.SearchHandler;
import com.yahoo.search.searchchain.SearchChainRegistry;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ApplicationStatusHandler
extends AbstractRequestHandler {
    private final JSONObject applicationJson;
    private final JSONArray clientsJson;
    private final JSONArray serversJson;
    private final JSONArray requestFiltersJson;
    private final JSONArray responseFiltersJson;
    private final JdiscBindingsConfig bindingsConfig;

    @Inject
    public ApplicationStatusHandler(ApplicationMetadataConfig metaConfig, ApplicationUserdataConfig userConfig, JdiscBindingsConfig bindingsConfig, ComponentRegistry<ClientProvider> clientProviderRegistry, ComponentRegistry<ServerProvider> serverProviderRegistry, ComponentRegistry<RequestFilterBase> requestFilterRegistry, ComponentRegistry<ResponseFilterBase> responseFilterRegistry) {
        this.applicationJson = ApplicationStatusHandler.renderApplicationConfigs(metaConfig, userConfig);
        this.clientsJson = ApplicationStatusHandler.renderRequestHandlers(bindingsConfig, clientProviderRegistry.allComponentsById());
        this.serversJson = ApplicationStatusHandler.renderObjectComponents(serverProviderRegistry.allComponentsById());
        this.requestFiltersJson = ApplicationStatusHandler.renderObjectComponents(requestFilterRegistry.allComponentsById());
        this.responseFiltersJson = ApplicationStatusHandler.renderObjectComponents(responseFilterRegistry.allComponentsById());
        this.bindingsConfig = bindingsConfig;
    }

    public ContentChannel handleRequest(Request request, ResponseHandler handler) {
        JSONObject json = new StatusResponse(this.applicationJson, this.clientsJson, this.serversJson, this.requestFiltersJson, this.responseFiltersJson, this.bindingsConfig).render();
        FastContentWriter writer = new FastContentWriter(new ResponseDispatch(){

            protected Response newResponse() {
                Response response = new Response(200);
                response.headers().add("Content-Type", Arrays.asList("application/json"));
                return response;
            }
        }.connect(handler));
        writer.write(json.toString());
        writer.close();
        return new IgnoredContent();
    }

    static JSONObject renderApplicationConfigs(ApplicationMetadataConfig metaConfig, ApplicationUserdataConfig userConfig) {
        JSONObject vespa = new JSONObject();
        ApplicationStatusHandler.putJson(vespa, "version", Vtag.currentVersion);
        JSONObject meta = new JSONObject();
        ApplicationStatusHandler.putJson(meta, "name", metaConfig.name());
        ApplicationStatusHandler.putJson(meta, "user", metaConfig.user());
        ApplicationStatusHandler.putJson(meta, "path", metaConfig.path());
        ApplicationStatusHandler.putJson(meta, "generation", metaConfig.generation());
        ApplicationStatusHandler.putJson(meta, "timestamp", metaConfig.timestamp());
        ApplicationStatusHandler.putJson(meta, "date", new Date(metaConfig.timestamp()).toString());
        ApplicationStatusHandler.putJson(meta, "checksum", metaConfig.checksum());
        JSONObject user = new JSONObject();
        ApplicationStatusHandler.putJson(user, "version", userConfig.version());
        JSONObject application = new JSONObject();
        ApplicationStatusHandler.putJson(application, "vespa", vespa);
        ApplicationStatusHandler.putJson(application, "meta", meta);
        ApplicationStatusHandler.putJson(application, "user", user);
        return application;
    }

    static JSONArray renderObjectComponents(Map<ComponentId, ?> componentsById) {
        JSONArray ret = new JSONArray();
        for (Map.Entry<ComponentId, ?> componentEntry : componentsById.entrySet()) {
            JSONObject jc = ApplicationStatusHandler.renderComponent(componentEntry.getValue(), componentEntry.getKey());
            ret.put((Object)jc);
        }
        return ret;
    }

    static JSONArray renderRequestHandlers(JdiscBindingsConfig bindingsConfig, Map<ComponentId, ? extends RequestHandler> handlersById) {
        JSONArray ret = new JSONArray();
        for (Map.Entry<ComponentId, ? extends RequestHandler> handlerEntry : handlersById.entrySet()) {
            String id = handlerEntry.getKey().stringValue();
            RequestHandler handler = handlerEntry.getValue();
            JSONObject handlerJson = ApplicationStatusHandler.renderComponent(handler, handlerEntry.getKey());
            ApplicationStatusHandler.addBindings(bindingsConfig, id, handlerJson);
            ret.put((Object)handlerJson);
        }
        return ret;
    }

    private static void addBindings(JdiscBindingsConfig bindingsConfig, String id, JSONObject handlerJson) {
        ArrayList<String> serverBindings = new ArrayList();
        ArrayList<String> clientBindings = new ArrayList();
        JdiscBindingsConfig.Handlers handlerConfig = bindingsConfig.handlers(id);
        if (handlerConfig != null) {
            serverBindings = handlerConfig.serverBindings();
            clientBindings = handlerConfig.clientBindings();
        }
        ApplicationStatusHandler.putJson(handlerJson, "serverBindings", ApplicationStatusHandler.renderBindings(serverBindings));
        ApplicationStatusHandler.putJson(handlerJson, "clientBindings", ApplicationStatusHandler.renderBindings(clientBindings));
    }

    private static JSONArray renderBindings(List<String> bindings) {
        JSONArray ret = new JSONArray();
        for (String binding : bindings) {
            ret.put((Object)binding);
        }
        return ret;
    }

    private static JSONArray renderAbstractComponents(List<? extends AbstractComponent> components) {
        JSONArray ret = new JSONArray();
        for (AbstractComponent abstractComponent : components) {
            JSONObject jc = ApplicationStatusHandler.renderComponent(abstractComponent, abstractComponent.getId());
            ret.put((Object)jc);
        }
        return ret;
    }

    private static JSONObject renderComponent(Object component, ComponentId id) {
        JSONObject jc = new JSONObject();
        ApplicationStatusHandler.putJson(jc, "id", id.stringValue());
        ApplicationStatusHandler.addBundleInfo(jc, component);
        return jc;
    }

    private static void addBundleInfo(JSONObject jsonObject, Object component) {
        BundleInfo bundleInfo = ApplicationStatusHandler.bundleInfo(component);
        ApplicationStatusHandler.putJson(jsonObject, "class", bundleInfo.className);
        ApplicationStatusHandler.putJson(jsonObject, "bundle", bundleInfo.bundleName);
    }

    private static BundleInfo bundleInfo(Object component) {
        try {
            Bundle bundle = FrameworkUtil.getBundle(component.getClass());
            String bundleName = bundle != null ? bundle.getSymbolicName() + ":" + bundle.getVersion() : "From classpath";
            return new BundleInfo(component.getClass().getName(), bundleName);
        }
        catch (Exception | NoClassDefFoundError e) {
            return new BundleInfo("Unavailable, reconfiguration in progress.", "");
        }
    }

    private static void putJson(JSONObject json, String key, Object value) {
        try {
            json.put(key, value);
        }
        catch (JSONException e) {
            throw new RuntimeException("Trying to add invalid JSON object with key '" + key + "' and value '" + value + "' - " + e.getMessage(), e);
        }
    }

    private class IgnoredContent
    implements ContentChannel {
        private IgnoredContent() {
        }

        public void write(ByteBuffer buf, CompletionHandler handler) {
            handler.completed();
        }

        public void close(CompletionHandler handler) {
            handler.completed();
        }
    }

    static final class StatusResponse {
        private final JSONObject applicationJson;
        private final JSONArray clientsJson;
        private final JSONArray serversJson;
        private final JSONArray requestFiltersJson;
        private final JSONArray responseFiltersJson;
        private final JdiscBindingsConfig bindingsConfig;

        StatusResponse(JSONObject applicationJson, JSONArray clientsJson, JSONArray serversJson, JSONArray requestFiltersJson, JSONArray responseFiltersJson, JdiscBindingsConfig bindingsConfig) {
            this.applicationJson = applicationJson;
            this.clientsJson = clientsJson;
            this.serversJson = serversJson;
            this.requestFiltersJson = requestFiltersJson;
            this.responseFiltersJson = responseFiltersJson;
            this.bindingsConfig = bindingsConfig;
        }

        public JSONObject render() {
            JSONObject root = new JSONObject();
            ApplicationStatusHandler.putJson(root, "application", this.applicationJson);
            ApplicationStatusHandler.putJson(root, "abstractComponents", ApplicationStatusHandler.renderAbstractComponents(Container.get().getComponentRegistry().allComponents()));
            ApplicationStatusHandler.putJson(root, "handlers", ApplicationStatusHandler.renderRequestHandlers(this.bindingsConfig, Container.get().getRequestHandlerRegistry().allComponentsById()));
            ApplicationStatusHandler.putJson(root, "clients", this.clientsJson);
            ApplicationStatusHandler.putJson(root, "servers", this.serversJson);
            ApplicationStatusHandler.putJson(root, "httpRequestFilters", this.requestFiltersJson);
            ApplicationStatusHandler.putJson(root, "httpResponseFilters", this.responseFiltersJson);
            ApplicationStatusHandler.putJson(root, "searchChains", StatusResponse.renderSearchChains(Container.get()));
            ApplicationStatusHandler.putJson(root, "docprocChains", StatusResponse.renderDocprocChains(Container.get()));
            ApplicationStatusHandler.putJson(root, "processingChains", StatusResponse.renderProcessingChains(Container.get()));
            return root;
        }

        private static JSONObject renderSearchChains(Container container) {
            for (RequestHandler h : container.getRequestHandlerRegistry().allComponents()) {
                if (!(h instanceof SearchHandler)) continue;
                SearchChainRegistry scReg = ((SearchHandler)h).getSearchChainRegistry();
                return StatusResponse.renderChains(scReg);
            }
            return new JSONObject();
        }

        private static JSONObject renderDocprocChains(Container container) {
            JSONObject ret = new JSONObject();
            for (RequestHandler h : container.getRequestHandlerRegistry().allComponents()) {
                if (!(h instanceof DocumentProcessingHandler)) continue;
                ComponentRegistry registry = ((DocumentProcessingHandler)h).getDocprocServiceRegistry();
                for (DocprocService service : registry.allComponents()) {
                    ApplicationStatusHandler.putJson(ret, service.getId().stringValue(), StatusResponse.renderCalls(service.getCallStack().iterator()));
                }
            }
            return ret;
        }

        private static JSONObject renderProcessingChains(Container container) {
            JSONObject ret = new JSONObject();
            for (RequestHandler h : container.getRequestHandlerRegistry().allComponents()) {
                if (!(h instanceof ProcessingHandler)) continue;
                ChainRegistry registry = ((ProcessingHandler)h).getChainRegistry();
                return StatusResponse.renderChains(registry);
            }
            return ret;
        }

        static JSONObject renderChains(ComponentRegistry<? extends Chain<?>> chains) {
            JSONObject ret = new JSONObject();
            for (Chain chain : chains.allComponents()) {
                ApplicationStatusHandler.putJson(ret, chain.getId().stringValue(), ApplicationStatusHandler.renderAbstractComponents(chain.components()));
            }
            return ret;
        }

        private static JSONArray renderCalls(Iterator<Call> components) {
            JSONArray ret = new JSONArray();
            while (components.hasNext()) {
                Call c = components.next();
                JSONObject jc = ApplicationStatusHandler.renderComponent(c.getDocumentProcessor(), c.getDocumentProcessor().getId());
                ret.put((Object)jc);
            }
            return ret;
        }
    }

    static final class BundleInfo {
        public final String className;
        public final String bundleName;

        BundleInfo(String className, String bundleName) {
            this.className = className;
            this.bundleName = bundleName;
        }
    }
}

