/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtProvider;
import java.io.IOException;
import java.util.logging.Logger;

public abstract class OrtProviderOptions
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(OrtProviderOptions.class.getName());
    protected final long nativeHandle;
    protected boolean closed;

    protected OrtProviderOptions(long nativeHandle) {
        this.nativeHandle = nativeHandle;
        this.closed = false;
    }

    protected static long getApiHandle() {
        return OnnxRuntime.ortApiHandle;
    }

    public abstract OrtProvider getProvider();

    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.close(OnnxRuntime.ortApiHandle, this.nativeHandle);
            this.closed = true;
        } else {
            logger.warning("Closing an already closed tensor.");
        }
    }

    protected void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("Trying to use a closed OrtProviderOptions");
        }
    }

    protected abstract void close(long var1, long var3);

    protected static long loadLibraryAndCreate(OrtProvider provider, OrtProviderSupplier createFunction) throws OrtException {
        switch (provider) {
            case CUDA: {
                if (OnnxRuntime.extractCUDA()) break;
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find CUDA shared provider");
            }
            case DNNL: {
                if (OnnxRuntime.extractDNNL()) break;
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find DNNL shared provider");
            }
            case OPEN_VINO: {
                if (OnnxRuntime.extractOpenVINO()) break;
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find OpenVINO shared provider");
            }
            case ROCM: {
                if (OnnxRuntime.extractROCM()) break;
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find ROCm shared provider");
            }
            case TENSOR_RT: {
                if (OnnxRuntime.extractTensorRT()) break;
                throw new OrtException(OrtException.OrtErrorCode.ORT_EP_FAIL, "Failed to find TensorRT shared provider");
            }
        }
        return createFunction.create();
    }

    static {
        try {
            OnnxRuntime.init();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load onnx-runtime library", e);
        }
    }

    @FunctionalInterface
    public static interface OrtProviderSupplier {
        public long create() throws OrtException;
    }
}

