/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.OnnxRuntime;
import ai.onnxruntime.OrtAllocator;
import ai.onnxruntime.OrtException;
import ai.onnxruntime.OrtLoggingLevel;
import ai.onnxruntime.OrtProvider;
import ai.onnxruntime.OrtSession;
import java.io.IOException;
import java.util.EnumSet;
import java.util.logging.Logger;

public final class OrtEnvironment
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(OrtEnvironment.class.getName());
    public static final String DEFAULT_NAME = "ort-java";
    private static volatile OrtEnvironment INSTANCE;
    private static volatile OrtLoggingLevel curLogLevel;
    private static volatile String curLoggingName;
    final long nativeHandle;
    final OrtAllocator defaultAllocator;

    public static synchronized OrtEnvironment getEnvironment() {
        if (INSTANCE == null) {
            return OrtEnvironment.getEnvironment(OrtLoggingLevel.ORT_LOGGING_LEVEL_WARNING, DEFAULT_NAME);
        }
        return INSTANCE;
    }

    public static OrtEnvironment getEnvironment(String name) {
        return OrtEnvironment.getEnvironment(OrtLoggingLevel.ORT_LOGGING_LEVEL_WARNING, name);
    }

    public static OrtEnvironment getEnvironment(OrtLoggingLevel logLevel) {
        return OrtEnvironment.getEnvironment(logLevel, DEFAULT_NAME);
    }

    public static synchronized OrtEnvironment getEnvironment(OrtLoggingLevel loggingLevel, String name) {
        if (INSTANCE == null) {
            try {
                INSTANCE = new OrtEnvironment(loggingLevel, name);
                curLogLevel = loggingLevel;
                curLoggingName = name;
            }
            catch (OrtException e) {
                throw new IllegalStateException("Failed to create OrtEnvironment", e);
            }
        } else if (loggingLevel.getValue() != curLogLevel.getValue() || !name.equals(curLoggingName)) {
            logger.warning("Tried to change OrtEnvironment's logging level or name while a reference exists.");
        }
        return INSTANCE;
    }

    public static synchronized OrtEnvironment getEnvironment(OrtLoggingLevel loggingLevel, String name, ThreadingOptions threadOptions) {
        if (INSTANCE == null) {
            try {
                INSTANCE = new OrtEnvironment(loggingLevel, name, threadOptions);
                curLogLevel = loggingLevel;
                curLoggingName = name;
            }
            catch (OrtException e) {
                throw new IllegalStateException("Failed to create OrtEnvironment", e);
            }
            return INSTANCE;
        }
        throw new IllegalStateException("Tried to specify the thread pool when creating an OrtEnvironment, but one already exists.");
    }

    private OrtEnvironment() throws OrtException {
        this(OrtLoggingLevel.ORT_LOGGING_LEVEL_WARNING, "java-default");
    }

    private OrtEnvironment(OrtLoggingLevel loggingLevel, String name) throws OrtException {
        this.nativeHandle = OrtEnvironment.createHandle(OnnxRuntime.ortApiHandle, loggingLevel.getValue(), name);
        this.defaultAllocator = new OrtAllocator(OrtEnvironment.getDefaultAllocator(OnnxRuntime.ortApiHandle), true);
        Runtime.getRuntime().addShutdownHook(new Thread(new OrtEnvCloser(OnnxRuntime.ortApiHandle, this.nativeHandle)));
    }

    private OrtEnvironment(OrtLoggingLevel loggingLevel, String name, ThreadingOptions threadOptions) throws OrtException {
        this.nativeHandle = OrtEnvironment.createHandle(OnnxRuntime.ortApiHandle, loggingLevel.getValue(), name, threadOptions.nativeHandle);
        this.defaultAllocator = new OrtAllocator(OrtEnvironment.getDefaultAllocator(OnnxRuntime.ortApiHandle), true);
        Runtime.getRuntime().addShutdownHook(new Thread(new OrtEnvCloser(OnnxRuntime.ortApiHandle, this.nativeHandle)));
    }

    public OrtSession createSession(String modelPath) throws OrtException {
        return this.createSession(modelPath, new OrtSession.SessionOptions());
    }

    public OrtSession createSession(String modelPath, OrtSession.SessionOptions options) throws OrtException {
        return this.createSession(modelPath, this.defaultAllocator, options);
    }

    OrtSession createSession(String modelPath, OrtAllocator allocator, OrtSession.SessionOptions options) throws OrtException {
        return new OrtSession(this, modelPath, allocator, options);
    }

    public OrtSession createSession(byte[] modelArray, OrtSession.SessionOptions options) throws OrtException {
        return this.createSession(modelArray, this.defaultAllocator, options);
    }

    public OrtSession createSession(byte[] modelArray) throws OrtException {
        return this.createSession(modelArray, new OrtSession.SessionOptions());
    }

    OrtSession createSession(byte[] modelArray, OrtAllocator allocator, OrtSession.SessionOptions options) throws OrtException {
        return new OrtSession(this, modelArray, allocator, options);
    }

    public void setTelemetry(boolean sendTelemetry) throws OrtException {
        OrtEnvironment.setTelemetry(OnnxRuntime.ortApiHandle, this.nativeHandle, sendTelemetry);
    }

    public String toString() {
        return "OrtEnvironment(name=" + curLoggingName + ",logLevel=" + (Object)((Object)curLogLevel) + ")";
    }

    public static EnumSet<OrtProvider> getAvailableProviders() {
        return OnnxRuntime.providers.clone();
    }

    private static native long createHandle(long var0, int var2, String var3) throws OrtException;

    private static native long createHandle(long var0, int var2, String var3, long var4) throws OrtException;

    private static native long getDefaultAllocator(long var0) throws OrtException;

    private static native void close(long var0, long var2) throws OrtException;

    private static native void setTelemetry(long var0, long var2, boolean var4) throws OrtException;

    @Override
    public void close() {
    }

    static {
        try {
            OnnxRuntime.init();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load onnx-runtime library", e);
        }
    }

    private static final class OrtEnvCloser
    implements Runnable {
        private final long apiHandle;
        private final long nativeHandle;

        OrtEnvCloser(long apiHandle, long nativeHandle) {
            this.apiHandle = apiHandle;
            this.nativeHandle = nativeHandle;
        }

        @Override
        public void run() {
            try {
                OrtEnvironment.close(this.apiHandle, this.nativeHandle);
            }
            catch (OrtException e) {
                System.err.println("Error closing OrtEnvironment, " + e);
            }
        }
    }

    public static final class ThreadingOptions
    implements AutoCloseable {
        private final long nativeHandle = ThreadingOptions.createThreadingOptions(OnnxRuntime.ortApiHandle);
        private boolean closed = false;

        private void checkClosed() {
            if (this.closed) {
                throw new IllegalStateException("Trying to use a closed ThreadingOptions");
            }
        }

        @Override
        public void close() {
            if (this.closed) {
                throw new IllegalStateException("Trying to close a closed ThreadingOptions.");
            }
            this.closeThreadingOptions(OnnxRuntime.ortApiHandle, this.nativeHandle);
            this.closed = true;
        }

        public void setGlobalInterOpNumThreads(int numThreads) throws OrtException {
            this.checkClosed();
            if (numThreads < 0) {
                throw new IllegalArgumentException("Number of threads must be non-negative.");
            }
            this.setGlobalInterOpNumThreads(OnnxRuntime.ortApiHandle, this.nativeHandle, numThreads);
        }

        public void setGlobalIntraOpNumThreads(int numThreads) throws OrtException {
            this.checkClosed();
            if (numThreads < 0) {
                throw new IllegalArgumentException("Number of threads must be non-negative.");
            }
            this.setGlobalIntraOpNumThreads(OnnxRuntime.ortApiHandle, this.nativeHandle, numThreads);
        }

        public void setGlobalSpinControl(boolean allowSpinning) throws OrtException {
            this.checkClosed();
            this.setGlobalSpinControl(OnnxRuntime.ortApiHandle, this.nativeHandle, allowSpinning ? 1 : 0);
        }

        public void setGlobalDenormalAsZero() throws OrtException {
            this.checkClosed();
            this.setGlobalDenormalAsZero(OnnxRuntime.ortApiHandle, this.nativeHandle);
        }

        private static native long createThreadingOptions(long var0);

        private native void setGlobalIntraOpNumThreads(long var1, long var3, int var5) throws OrtException;

        private native void setGlobalInterOpNumThreads(long var1, long var3, int var5) throws OrtException;

        private native void setGlobalSpinControl(long var1, long var3, int var5) throws OrtException;

        private native void setGlobalDenormalAsZero(long var1, long var3) throws OrtException;

        private native void closeThreadingOptions(long var1, long var3);

        static {
            try {
                OnnxRuntime.init();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load onnx-runtime library", e);
            }
        }
    }
}

