/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.onnxruntime;

import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class OnnxBundleActivator
implements BundleActivator {
    private static final String SKIP_PREFIX = "onnxruntime.native.";
    private static final String SKIP_SUFFIX = ".skip";
    private static final String SKIP_VALUE = "true";
    private static final String[] LIBRARY_NAMES = new String[]{"onnxruntime", "onnxruntime4j_jni"};
    private static final Logger log = Logger.getLogger(OnnxBundleActivator.class.getName());

    public void start(BundleContext ctx) {
        String skipAll = OnnxBundleActivator.class.getSimpleName() + SKIP_SUFFIX;
        if (SKIP_VALUE.equals(System.getProperty(skipAll))) {
            log.info("skip loading of native libraries");
            return;
        }
        for (String libName : LIBRARY_NAMES) {
            String skipProp = SKIP_PREFIX + libName + SKIP_SUFFIX;
            if (SKIP_VALUE.equals(System.getProperty(skipProp))) {
                log.fine("already loaded native library " + libName + ", skipping");
                continue;
            }
            log.fine("loading native library: " + libName);
            try {
                System.loadLibrary(libName);
                System.setProperty(skipProp, SKIP_VALUE);
                log.info("loaded native library OK: " + libName);
            }
            catch (Exception | UnsatisfiedLinkError e) {
                log.info("Could not load native library '" + libName + "' because: " + e.getMessage());
            }
        }
    }

    public void stop(BundleContext ctx) {
        for (String libName : LIBRARY_NAMES) {
            String skipProp = SKIP_PREFIX + libName + SKIP_SUFFIX;
            if (SKIP_VALUE.equals(System.getProperty(skipProp))) {
                log.info("will unload native library: " + libName);
            }
            System.clearProperty(skipProp);
        }
    }
}

