/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import ai.onnxruntime.MapInfo;
import ai.onnxruntime.OnnxJavaType;
import ai.onnxruntime.ValueInfo;

public class SequenceInfo
implements ValueInfo {
    public final boolean sequenceOfMaps;
    public final OnnxJavaType sequenceType;
    public final MapInfo mapInfo;
    public final int length;

    SequenceInfo(int length, OnnxJavaType sequenceType) {
        this.length = length;
        this.sequenceType = sequenceType;
        this.sequenceOfMaps = false;
        this.mapInfo = null;
    }

    SequenceInfo(int length, MapInfo mapInfo) {
        this.length = length;
        this.sequenceOfMaps = true;
        this.mapInfo = mapInfo;
        this.sequenceType = OnnxJavaType.UNKNOWN;
    }

    SequenceInfo(int length, OnnxJavaType keyType, OnnxJavaType valueType) {
        this.length = length;
        this.sequenceType = OnnxJavaType.UNKNOWN;
        this.sequenceOfMaps = true;
        this.mapInfo = new MapInfo(keyType, valueType);
    }

    public boolean isSequenceOfMaps() {
        return this.sequenceOfMaps;
    }

    public String toString() {
        String initial = "SequenceInfo(length=" + (this.length == -1 ? "UNKNOWN" : Integer.valueOf(this.length));
        if (this.sequenceOfMaps) {
            return initial + ",type=" + this.mapInfo.toString() + ")";
        }
        return initial + ",type=" + this.sequenceType.toString() + ")";
    }
}

