/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

import java.util.HashMap;
import java.util.Map;

public enum OrtProvider {
    CPU("CPUExecutionProvider"),
    CUDA("CUDAExecutionProvider"),
    DNNL("DnnlExecutionProvider"),
    OPEN_VINO("OpenVINOExecutionProvider"),
    NUPHAR("NupharExecutionProvider"),
    VITIS_AI("VitisAIExecutionProvider"),
    TENSOR_RT("TensorrtExecutionProvider"),
    NNAPI("NnapiExecutionProvider"),
    RK_NPU("RknpuExecutionProvider"),
    DIRECT_ML("DmlExecutionProvider"),
    MI_GRAPH_X("MIGraphXExecutionProvider"),
    ACL("ACLExecutionProvider"),
    ARM_NN("ArmNNExecutionProvider"),
    ROCM("ROCMExecutionProvider"),
    CORE_ML("CoreMLExecutionProvider");

    private static final Map<String, OrtProvider> valueMap;
    private final String name;

    private OrtProvider(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static OrtProvider mapFromName(String name) {
        OrtProvider provider = valueMap.get(name);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown execution provider - " + name);
        }
        return provider;
    }

    static {
        valueMap = new HashMap<String, OrtProvider>(OrtProvider.values().length);
        for (OrtProvider p : OrtProvider.values()) {
            valueMap.put(p.name, p);
        }
    }
}

