/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.shared;

import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.config.subscription.ConfigGetter;
import com.yahoo.jdisc.AbstractResource;
import com.yahoo.messagebus.DestinationSessionParams;
import com.yahoo.messagebus.IntermediateSessionParams;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.MessageBusParams;
import com.yahoo.messagebus.SourceSessionParams;
import com.yahoo.messagebus.network.Network;
import com.yahoo.messagebus.network.rpc.RPCNetwork;
import com.yahoo.messagebus.network.rpc.RPCNetworkParams;
import com.yahoo.messagebus.shared.NullNetwork;
import com.yahoo.messagebus.shared.SharedDestinationSession;
import com.yahoo.messagebus.shared.SharedIntermediateSession;
import com.yahoo.messagebus.shared.SharedSourceSession;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SharedMessageBus
extends AbstractResource {
    private static final Logger log = Logger.getLogger(SharedMessageBus.class.getName());
    private final MessageBus mbus;

    public SharedMessageBus(MessageBus mbus) {
        this.mbus = Objects.requireNonNull(mbus);
    }

    public MessageBus messageBus() {
        return this.mbus;
    }

    protected void destroy() {
        log.log(Level.FINE, "Destroying shared message bus.");
        this.mbus.destroy();
    }

    public SharedSourceSession newSourceSession(SourceSessionParams params) {
        return new SharedSourceSession(this, params);
    }

    public SharedIntermediateSession newIntermediateSession(IntermediateSessionParams params) {
        return new SharedIntermediateSession(this, params);
    }

    public SharedDestinationSession newDestinationSession(DestinationSessionParams params) {
        return new SharedDestinationSession(this, params);
    }

    public static SharedMessageBus newInstance(MessageBusParams mbusParams, RPCNetworkParams netParams) {
        return new SharedMessageBus(new MessageBus(SharedMessageBus.newNetwork(netParams), mbusParams));
    }

    private static Network newNetwork(RPCNetworkParams params) {
        SlobroksConfig cfg = params.getSlobroksConfig();
        if (cfg == null) {
            cfg = (SlobroksConfig)ConfigGetter.getConfig(SlobroksConfig.class, (String)params.getSlobrokConfigId());
        }
        if (cfg.slobrok().isEmpty()) {
            return new NullNetwork();
        }
        return new RPCNetwork(params);
    }
}

