/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.messagebus;

import com.yahoo.component.annotation.Inject;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.container.jdisc.config.SessionConfig;
import com.yahoo.container.jdisc.messagebus.MbusServerProvider;
import com.yahoo.container.jdisc.messagebus.SessionCache;
import com.yahoo.jdisc.ReferencedResource;
import com.yahoo.messagebus.AllPassThrottlePolicy;
import com.yahoo.messagebus.IntermediateSessionParams;
import com.yahoo.messagebus.SourceSessionParams;
import com.yahoo.messagebus.ThrottlePolicy;
import com.yahoo.messagebus.jdisc.MbusClient;
import com.yahoo.messagebus.shared.ClientSession;
import com.yahoo.messagebus.shared.SharedIntermediateSession;
import com.yahoo.messagebus.shared.SharedSourceSession;

public class MbusClientProvider
implements Provider<MbusClient> {
    private final MbusClient client;

    private static MbusClient createSourceClient(SessionCache sessionCache, boolean setAllPassThrottlePolicy) {
        SourceSessionParams sourceSessionParams = new SourceSessionParams();
        if (setAllPassThrottlePolicy) {
            sourceSessionParams.setThrottlePolicy((ThrottlePolicy)new AllPassThrottlePolicy());
        }
        try (ReferencedResource<SharedSourceSession> ref = sessionCache.retainSource(sourceSessionParams);){
            MbusClient mbusClient = new MbusClient((ClientSession)ref.getResource());
            return mbusClient;
        }
    }

    @Inject
    public MbusClientProvider(SessionCache sessionCache, SessionConfig sessionConfig) {
        switch (sessionConfig.type()) {
            case INTERMEDIATE: {
                IntermediateSessionParams intermediateSessionParams = MbusServerProvider.createIntermediateSessionParams(true, sessionConfig.name());
                try (ReferencedResource<SharedIntermediateSession> ref = sessionCache.retainIntermediate(intermediateSessionParams);){
                    this.client = new MbusClient((ClientSession)ref.getResource());
                    break;
                }
            }
            case SOURCE: {
                this.client = MbusClientProvider.createSourceClient(sessionCache, false);
                break;
            }
            case INTERNAL: {
                this.client = MbusClientProvider.createSourceClient(sessionCache, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown session type: " + String.valueOf((Object)sessionConfig.type()));
            }
        }
    }

    public MbusClient get() {
        return this.client;
    }

    public void deconstruct() {
        this.client.release();
    }
}

