/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.messagebus;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.container.jdisc.ContainerMbusConfig;
import com.yahoo.container.jdisc.messagebus.NetworkMultiplexerProvider;
import com.yahoo.document.DocumentTypeManager;
import com.yahoo.documentapi.messagebus.protocol.DocumentProtocol;
import com.yahoo.jdisc.AbstractResource;
import com.yahoo.jdisc.ReferencedResource;
import com.yahoo.jdisc.References;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.jdisc.SharedResource;
import com.yahoo.messagebus.ConfigAgent;
import com.yahoo.messagebus.ConfigHandler;
import com.yahoo.messagebus.DynamicThrottlePolicy;
import com.yahoo.messagebus.IntermediateSessionParams;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.MessageBusParams;
import com.yahoo.messagebus.MessagebusConfig;
import com.yahoo.messagebus.Protocol;
import com.yahoo.messagebus.SourceSessionParams;
import com.yahoo.messagebus.StaticThrottlePolicy;
import com.yahoo.messagebus.ThrottlePolicy;
import com.yahoo.messagebus.network.NetworkMultiplexer;
import com.yahoo.messagebus.shared.SharedIntermediateSession;
import com.yahoo.messagebus.shared.SharedMessageBus;
import com.yahoo.messagebus.shared.SharedSourceSession;
import com.yahoo.yolean.concurrent.Memoized;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SessionCache
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(SessionCache.class.getName());
    private final Memoized<SharedMessageBus, RuntimeException> messageBus;
    private final Object intermediateLock = new Object();
    private final Map<String, SharedIntermediateSession> intermediates = new HashMap<String, SharedIntermediateSession>();
    private final IntermediateSessionCreator intermediatesCreator = new IntermediateSessionCreator();
    private final Object sourceLock = new Object();
    private final Map<SourceSessionKey, SharedSourceSession> sources = new HashMap<SourceSessionKey, SharedSourceSession>();
    private final SourceSessionCreator sourcesCreator = new SourceSessionCreator();

    @Inject
    public SessionCache(NetworkMultiplexerProvider nets, ContainerMbusConfig containerMbusConfig, DocumentTypeManager documentTypeManager, MessagebusConfig messagebusConfig) {
        this(nets::net, containerMbusConfig, documentTypeManager, messagebusConfig);
    }

    public SessionCache(Supplier<NetworkMultiplexer> net, ContainerMbusConfig containerMbusConfig, DocumentTypeManager documentTypeManager, MessagebusConfig messagebusConfig) {
        this(net, containerMbusConfig, messagebusConfig, (Protocol)new DocumentProtocol(documentTypeManager));
    }

    public SessionCache(Supplier<NetworkMultiplexer> net, ContainerMbusConfig containerMbusConfig, MessagebusConfig messagebusConfig, Protocol protocol) {
        this.messageBus = new Memoized(() -> SessionCache.createSharedMessageBus((NetworkMultiplexer)net.get(), containerMbusConfig, messagebusConfig, protocol), AbstractResource::release);
    }

    public void deconstruct() {
        this.messageBus.close();
    }

    private SharedMessageBus bus() {
        return (SharedMessageBus)((Object)this.messageBus.get());
    }

    private static SharedMessageBus createSharedMessageBus(NetworkMultiplexer net, ContainerMbusConfig mbusConfig, MessagebusConfig messagebusConfig, Protocol protocol) {
        MessageBusParams mbusParams = new MessageBusParams().addProtocol(protocol);
        mbusParams.setMaxPendingCount(mbusConfig.maxpendingcount());
        MessageBus bus = new MessageBus(net, mbusParams);
        new ConfigAgent(messagebusConfig, (ConfigHandler)bus);
        return new SharedMessageBus(bus);
    }

    ReferencedResource<SharedIntermediateSession> retainIntermediate(IntermediateSessionParams p) {
        return this.intermediatesCreator.retain(this.intermediateLock, this.intermediates, p);
    }

    public ReferencedResource<SharedSourceSession> retainSource(SourceSessionParams p) {
        return this.sourcesCreator.retain(this.sourceLock, this.sources, p);
    }

    private class IntermediateSessionCreator
    extends SessionCreator<IntermediateSessionParams, String, SharedIntermediateSession> {
        private IntermediateSessionCreator() {
        }

        @Override
        SharedIntermediateSession create(IntermediateSessionParams p) {
            log.log(Level.FINE, "Creating new intermediate session " + p.getName());
            return SessionCache.this.bus().newIntermediateSession(p);
        }

        @Override
        String buildKey(IntermediateSessionParams p) {
            return p.getName();
        }

        @Override
        void logReuse(SharedIntermediateSession session) {
            log.log(Level.FINE, "Reusing intermediate session " + session.name());
        }
    }

    private class SourceSessionCreator
    extends SessionCreator<SourceSessionParams, SourceSessionKey, SharedSourceSession> {
        private SourceSessionCreator() {
        }

        @Override
        SharedSourceSession create(SourceSessionParams p) {
            log.log(Level.FINE, "Creating new source session.");
            return SessionCache.this.bus().newSourceSession(p);
        }

        @Override
        SourceSessionKey buildKey(SourceSessionParams p) {
            return new SourceSessionKey(p);
        }

        @Override
        void logReuse(SharedSourceSession session) {
            log.log(Level.FINE, "Reusing source session.");
        }
    }

    static class SourceSessionKey {
        private final double timeout;
        private final ThrottlePolicySignature policy;

        SourceSessionKey(SourceSessionParams p) {
            this.timeout = p.getTimeout();
            this.policy = SourceSessionKey.createSignature(p.getThrottlePolicy());
        }

        private static ThrottlePolicySignature createSignature(ThrottlePolicy policy) {
            Class<?> policyClass = policy.getClass();
            if (policyClass == DynamicThrottlePolicy.class) {
                return new DynamicThrottlePolicySignature((DynamicThrottlePolicy)policy);
            }
            if (policyClass == StaticThrottlePolicy.class) {
                return new StaticThrottlePolicySignature((StaticThrottlePolicy)policy);
            }
            return new UnknownThrottlePolicySignature(policy);
        }

        public String toString() {
            return "SourceSessionKey{timeout=" + this.timeout + ", policy=" + this.policy + "}";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = prime * result + (this.policy == null ? 0 : this.policy.hashCode());
            long temp = Double.doubleToLongBits(this.timeout);
            result = prime * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceSessionKey other = (SourceSessionKey)obj;
            if (this.policy == null ? other.policy != null : !this.policy.equals(other.policy)) {
                return false;
            }
            return Double.doubleToLongBits(this.timeout) == Double.doubleToLongBits(other.timeout);
        }
    }

    static class UnknownThrottlePolicySignature
    extends ThrottlePolicySignature {
        private final ThrottlePolicy policy;

        UnknownThrottlePolicySignature(ThrottlePolicy policy) {
            this.policy = policy;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other.getClass() != this.getClass()) {
                return false;
            }
            return ((UnknownThrottlePolicySignature)other).policy == this.policy;
        }
    }

    static final class DynamicThrottlePolicySignature
    extends ThrottlePolicySignature {
        private final int maxPending;
        private final double maxWindowSize;
        private final double minWindowSize;
        private final double windowSizeBackoff;
        private final double windowSizeIncrement;

        DynamicThrottlePolicySignature(DynamicThrottlePolicy policy) {
            this.maxPending = policy.getMaxPendingCount();
            this.maxWindowSize = policy.getMaxWindowSize();
            this.minWindowSize = policy.getMinWindowSize();
            this.windowSizeBackoff = policy.getWindowSizeBackOff();
            this.windowSizeIncrement = policy.getWindowSizeIncrement();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = prime * result + this.maxPending;
            long temp = Double.doubleToLongBits(this.maxWindowSize);
            result = prime * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.minWindowSize);
            result = prime * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.windowSizeBackoff);
            result = prime * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.windowSizeIncrement);
            result = prime * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DynamicThrottlePolicySignature)) {
                return false;
            }
            DynamicThrottlePolicySignature other = (DynamicThrottlePolicySignature)obj;
            if (this.maxPending != other.maxPending) {
                return false;
            }
            if (Double.doubleToLongBits(this.maxWindowSize) != Double.doubleToLongBits(other.maxWindowSize)) {
                return false;
            }
            if (Double.doubleToLongBits(this.minWindowSize) != Double.doubleToLongBits(other.minWindowSize)) {
                return false;
            }
            if (Double.doubleToLongBits(this.windowSizeBackoff) != Double.doubleToLongBits(other.windowSizeBackoff)) {
                return false;
            }
            return Double.doubleToLongBits(this.windowSizeIncrement) == Double.doubleToLongBits(other.windowSizeIncrement);
        }
    }

    static final class StaticThrottlePolicySignature
    extends ThrottlePolicySignature {
        private final int maxPendingCount;
        private final long maxPendingSize;

        StaticThrottlePolicySignature(StaticThrottlePolicy policy) {
            this.maxPendingCount = policy.getMaxPendingCount();
            this.maxPendingSize = policy.getMaxPendingSize();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = prime * result + this.maxPendingCount;
            result = prime * result + (int)(this.maxPendingSize ^ this.maxPendingSize >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof StaticThrottlePolicySignature)) {
                return false;
            }
            StaticThrottlePolicySignature other = (StaticThrottlePolicySignature)obj;
            return this.maxPendingCount == other.maxPendingCount && this.maxPendingSize == other.maxPendingSize;
        }
    }

    static class ThrottlePolicySignature {
        ThrottlePolicySignature() {
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }
    }

    private static abstract class SessionCreator<PARAMS, KEY, SESSION extends SharedResource> {
        private SessionCreator() {
        }

        abstract SESSION create(PARAMS var1);

        abstract KEY buildKey(PARAMS var1);

        abstract void logReuse(SESSION var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ReferencedResource<SESSION> retain(Object lock, Map<KEY, SESSION> registry, PARAMS p) {
            ResourceReference sessionReference;
            Object session;
            KEY key = this.buildKey(p);
            Object object = lock;
            synchronized (object) {
                session = (SharedResource)registry.get(key);
                if (session == null) {
                    session = this.createAndStore(registry, p, key);
                    sessionReference = References.fromResource((SharedResource)session);
                } else {
                    try {
                        sessionReference = session.refer((Object)this);
                        this.logReuse(session);
                    }
                    catch (IllegalStateException e) {
                        session = this.createAndStore(registry, p, key);
                        sessionReference = References.fromResource((SharedResource)session);
                    }
                }
            }
            return new ReferencedResource(session, sessionReference);
        }

        SESSION createAndStore(Map<KEY, SESSION> registry, PARAMS p, KEY key) {
            SESSION session = this.create(p);
            registry.put(key, session);
            return session;
        }
    }
}

