/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.jdisc;

import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageHandler;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.jdisc.MbusRequest;
import com.yahoo.messagebus.jdisc.MbusResponse;
import com.yahoo.messagebus.jdisc.StatusCodes;

public abstract class MbusRequestHandler
extends AbstractRequestHandler
implements MessageHandler {
    public ContentChannel handleRequest(Request request, ResponseHandler handler) {
        if (!(request instanceof MbusRequest)) {
            throw new UnsupportedOperationException("Expected MbusRequest, got " + request.getClass().getName() + ".");
        }
        Message msg = ((MbusRequest)request).getMessage();
        msg.pushHandler((ReplyHandler)new RespondingReplyHandler(handler));
        this.handleMessage(msg);
        return null;
    }

    private static class RespondingReplyHandler
    implements ReplyHandler {
        private final ResponseHandler handler;

        RespondingReplyHandler(ResponseHandler handler) {
            this.handler = handler;
        }

        public void handleReply(Reply reply) {
            MbusResponse response = new MbusResponse(StatusCodes.fromMbusReply(reply), reply);
            this.handler.handleResponse((Response)response).close((CompletionHandler)IgnoringCompletionHandler.INSTANCE);
        }
    }

    private static class IgnoringCompletionHandler
    implements CompletionHandler {
        public static final IgnoringCompletionHandler INSTANCE = new IgnoringCompletionHandler();

        private IgnoringCompletionHandler() {
        }

        public void completed() {
        }

        public void failed(Throwable t) {
        }
    }
}

