/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.EnumNode;
import com.yahoo.config.IntegerNode;
import java.util.HashSet;
import java.util.Set;

public final class ContainerMbusConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "fb5356b8d0f0186759be0ee5856daaf9";
    public static final String CONFIG_DEF_NAME = "container-mbus";
    public static final String CONFIG_DEF_NAMESPACE = "container.jdisc";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container.jdisc", "port int default=0", "numconnectionspertarget int default=1", "numthreads int default=2", "optimize_for enum {LATENCY, THROUGHPUT} default=LATENCY", "transport_events_before_wakeup int default=1", "maxpendingcount int default=2048", "enabled bool default=false", "maxpendingsize int default=100", "maxConcurrentFactor double default=0.2 range=[0.0-1.0]", "documentExpansionFactor double default=80.0", "containerCoreMemory int default=150"};
    private final IntegerNode port;
    private final IntegerNode numconnectionspertarget;
    private final IntegerNode numthreads;
    private final Optimize_for optimize_for;
    private final IntegerNode transport_events_before_wakeup;
    private final IntegerNode maxpendingcount;
    private final BooleanNode enabled;
    private final IntegerNode maxpendingsize;
    private final DoubleNode maxConcurrentFactor;
    private final DoubleNode documentExpansionFactor;
    private final IntegerNode containerCoreMemory;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ContainerMbusConfig(Builder builder) {
        this(builder, true);
    }

    private ContainerMbusConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for container-mbus must be initialized: " + builder.__uninitialized);
        }
        this.port = builder.port == null ? new IntegerNode(0) : new IntegerNode(builder.port.intValue());
        this.numconnectionspertarget = builder.numconnectionspertarget == null ? new IntegerNode(1) : new IntegerNode(builder.numconnectionspertarget.intValue());
        this.numthreads = builder.numthreads == null ? new IntegerNode(2) : new IntegerNode(builder.numthreads.intValue());
        this.optimize_for = builder.optimize_for == null ? new Optimize_for(Optimize_for.LATENCY) : new Optimize_for(builder.optimize_for);
        this.transport_events_before_wakeup = builder.transport_events_before_wakeup == null ? new IntegerNode(1) : new IntegerNode(builder.transport_events_before_wakeup.intValue());
        this.maxpendingcount = builder.maxpendingcount == null ? new IntegerNode(2048) : new IntegerNode(builder.maxpendingcount.intValue());
        this.enabled = builder.enabled == null ? new BooleanNode(false) : new BooleanNode(builder.enabled.booleanValue());
        this.maxpendingsize = builder.maxpendingsize == null ? new IntegerNode(100) : new IntegerNode(builder.maxpendingsize.intValue());
        this.maxConcurrentFactor = builder.maxConcurrentFactor == null ? new DoubleNode(0.2) : new DoubleNode(builder.maxConcurrentFactor.doubleValue());
        this.documentExpansionFactor = builder.documentExpansionFactor == null ? new DoubleNode(80.0) : new DoubleNode(builder.documentExpansionFactor.doubleValue());
        this.containerCoreMemory = builder.containerCoreMemory == null ? new IntegerNode(150) : new IntegerNode(builder.containerCoreMemory.intValue());
    }

    public int port() {
        return this.port.value();
    }

    public int numconnectionspertarget() {
        return this.numconnectionspertarget.value();
    }

    public int numthreads() {
        return this.numthreads.value();
    }

    public Optimize_for.Enum optimize_for() {
        return (Optimize_for.Enum)((Object)this.optimize_for.value());
    }

    public int transport_events_before_wakeup() {
        return this.transport_events_before_wakeup.value();
    }

    public int maxpendingcount() {
        return this.maxpendingcount.value();
    }

    public boolean enabled() {
        return this.enabled.value();
    }

    public int maxpendingsize() {
        return this.maxpendingsize.value();
    }

    public double maxConcurrentFactor() {
        return this.maxConcurrentFactor.value();
    }

    public double documentExpansionFactor() {
        return this.documentExpansionFactor.value();
    }

    public int containerCoreMemory() {
        return this.containerCoreMemory.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ContainerMbusConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private Integer port = null;
        private Integer numconnectionspertarget = null;
        private Integer numthreads = null;
        private Optimize_for.Enum optimize_for = null;
        private Integer transport_events_before_wakeup = null;
        private Integer maxpendingcount = null;
        private Boolean enabled = null;
        private Integer maxpendingsize = null;
        private Double maxConcurrentFactor = null;
        private Double documentExpansionFactor = null;
        private Integer containerCoreMemory = null;
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ContainerMbusConfig config) {
            this.port(config.port());
            this.numconnectionspertarget(config.numconnectionspertarget());
            this.numthreads(config.numthreads());
            this.optimize_for(config.optimize_for());
            this.transport_events_before_wakeup(config.transport_events_before_wakeup());
            this.maxpendingcount(config.maxpendingcount());
            this.enabled(config.enabled());
            this.maxpendingsize(config.maxpendingsize());
            this.maxConcurrentFactor(config.maxConcurrentFactor());
            this.documentExpansionFactor(config.documentExpansionFactor());
            this.containerCoreMemory(config.containerCoreMemory());
        }

        private Builder override(Builder __superior) {
            if (__superior.port != null) {
                this.port(__superior.port);
            }
            if (__superior.numconnectionspertarget != null) {
                this.numconnectionspertarget(__superior.numconnectionspertarget);
            }
            if (__superior.numthreads != null) {
                this.numthreads(__superior.numthreads);
            }
            if (__superior.optimize_for != null) {
                this.optimize_for(__superior.optimize_for);
            }
            if (__superior.transport_events_before_wakeup != null) {
                this.transport_events_before_wakeup(__superior.transport_events_before_wakeup);
            }
            if (__superior.maxpendingcount != null) {
                this.maxpendingcount(__superior.maxpendingcount);
            }
            if (__superior.enabled != null) {
                this.enabled(__superior.enabled);
            }
            if (__superior.maxpendingsize != null) {
                this.maxpendingsize(__superior.maxpendingsize);
            }
            if (__superior.maxConcurrentFactor != null) {
                this.maxConcurrentFactor(__superior.maxConcurrentFactor);
            }
            if (__superior.documentExpansionFactor != null) {
                this.documentExpansionFactor(__superior.documentExpansionFactor);
            }
            if (__superior.containerCoreMemory != null) {
                this.containerCoreMemory(__superior.containerCoreMemory);
            }
            return this;
        }

        public Builder port(int __value) {
            this.port = __value;
            return this;
        }

        private Builder port(String __value) {
            return this.port(Integer.valueOf(__value));
        }

        public Builder numconnectionspertarget(int __value) {
            this.numconnectionspertarget = __value;
            return this;
        }

        private Builder numconnectionspertarget(String __value) {
            return this.numconnectionspertarget(Integer.valueOf(__value));
        }

        public Builder numthreads(int __value) {
            this.numthreads = __value;
            return this;
        }

        private Builder numthreads(String __value) {
            return this.numthreads(Integer.valueOf(__value));
        }

        public Builder optimize_for(Optimize_for.Enum __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.optimize_for = __value;
            return this;
        }

        private Builder optimize_for(String __value) {
            return this.optimize_for(Optimize_for.Enum.valueOf(__value));
        }

        public Builder transport_events_before_wakeup(int __value) {
            this.transport_events_before_wakeup = __value;
            return this;
        }

        private Builder transport_events_before_wakeup(String __value) {
            return this.transport_events_before_wakeup(Integer.valueOf(__value));
        }

        public Builder maxpendingcount(int __value) {
            this.maxpendingcount = __value;
            return this;
        }

        private Builder maxpendingcount(String __value) {
            return this.maxpendingcount(Integer.valueOf(__value));
        }

        public Builder enabled(boolean __value) {
            this.enabled = __value;
            return this;
        }

        private Builder enabled(String __value) {
            return this.enabled(Boolean.valueOf(__value));
        }

        public Builder maxpendingsize(int __value) {
            this.maxpendingsize = __value;
            return this;
        }

        private Builder maxpendingsize(String __value) {
            return this.maxpendingsize(Integer.valueOf(__value));
        }

        public Builder maxConcurrentFactor(double __value) {
            this.maxConcurrentFactor = __value;
            return this;
        }

        private Builder maxConcurrentFactor(String __value) {
            return this.maxConcurrentFactor(Double.valueOf(__value));
        }

        public Builder documentExpansionFactor(double __value) {
            this.documentExpansionFactor = __value;
            return this;
        }

        private Builder documentExpansionFactor(String __value) {
            return this.documentExpansionFactor(Double.valueOf(__value));
        }

        public Builder containerCoreMemory(int __value) {
            this.containerCoreMemory = __value;
            return this;
        }

        private Builder containerCoreMemory(String __value) {
            return this.containerCoreMemory(Integer.valueOf(__value));
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ContainerMbusConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ContainerMbusConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ContainerMbusConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ContainerMbusConfig build() {
            return new ContainerMbusConfig(this);
        }
    }

    public static final class Optimize_for
    extends EnumNode<Enum> {
        public static final Enum LATENCY = Enum.LATENCY;
        public static final Enum THROUGHPUT = Enum.THROUGHPUT;

        public Optimize_for() {
            this.value = null;
        }

        public Optimize_for(Enum enumValue) {
            super(enumValue != null);
            this.value = enumValue;
        }

        protected boolean doSetValue(String name) {
            try {
                this.value = Enum.valueOf(name);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public static enum Enum {
            LATENCY,
            THROUGHPUT;

        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

