/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.jdisc.test;

import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.slobrok.server.Slobrok;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.MessageBusParams;
import com.yahoo.messagebus.Protocol;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Result;
import com.yahoo.messagebus.SourceSession;
import com.yahoo.messagebus.SourceSessionParams;
import com.yahoo.messagebus.jdisc.test.ReplyQueue;
import com.yahoo.messagebus.jdisc.test.TestUtils;
import com.yahoo.messagebus.network.Network;
import com.yahoo.messagebus.network.local.LocalNetwork;
import com.yahoo.messagebus.network.rpc.RPCNetwork;
import com.yahoo.messagebus.network.rpc.RPCNetworkParams;
import com.yahoo.messagebus.test.SimpleProtocol;
import java.util.concurrent.TimeUnit;

public class RemoteClient {
    private final Slobrok slobrok;
    private final MessageBus mbus;
    private final ReplyQueue queue = new ReplyQueue();
    private final SourceSession session;

    private RemoteClient(Protocol protocol, boolean network) {
        this.slobrok = RemoteClient.newSlobrok();
        this.mbus = network ? new MessageBus((Network)new RPCNetwork(new RPCNetworkParams().setSlobroksConfig(this.slobroksConfig())), new MessageBusParams().addProtocol(protocol)) : new MessageBus((Network)new LocalNetwork(), new MessageBusParams().addProtocol(protocol));
        this.session = this.mbus.createSourceSession(new SourceSessionParams().setThrottlePolicy(null).setReplyHandler((ReplyHandler)this.queue));
    }

    public Result sendMessage(Message msg) {
        return this.session.send(msg);
    }

    public Reply awaitReply(int timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.awaitReply(timeout, unit);
    }

    public SlobroksConfig slobroksConfig() {
        return TestUtils.configFor(this.slobrok);
    }

    public void close() {
        this.session.destroy();
        this.mbus.destroy();
        this.slobrok.stop();
    }

    public static RemoteClient newInstanceWithInternSlobrok(boolean network) {
        return new RemoteClient((Protocol)new SimpleProtocol(), network);
    }

    public static RemoteClient newInstanceWithProtocolAndInternSlobrok(Protocol protocol, boolean network) {
        return new RemoteClient(protocol, network);
    }

    private static Slobrok newSlobrok() {
        Slobrok slobrok;
        try {
            slobrok = new Slobrok();
        }
        catch (ListenFailedException e) {
            throw new IllegalStateException(e);
        }
        return slobrok;
    }
}

