/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.jdisc;

import com.google.inject.Inject;
import com.yahoo.jdisc.AbstractResource;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.service.CurrentContainer;
import com.yahoo.jdisc.service.ServerProvider;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageHandler;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.Routable;
import com.yahoo.messagebus.jdisc.IgnoredCompletionHandler;
import com.yahoo.messagebus.jdisc.MbusRequest;
import com.yahoo.messagebus.jdisc.MbusResponse;
import com.yahoo.messagebus.jdisc.StatusCodes;
import com.yahoo.messagebus.shared.ServerSession;
import java.net.URI;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MbusServer
extends AbstractResource
implements ServerProvider,
MessageHandler {
    private static final Logger log = Logger.getLogger(MbusServer.class.getName());
    private final AtomicReference<State> runState = new AtomicReference<State>(State.INITIALIZING);
    private final CurrentContainer container;
    private final ServerSession session;
    private final URI uri;
    private final ResourceReference sessionReference;

    @Inject
    public MbusServer(CurrentContainer container, ServerSession session) {
        this.container = container;
        this.session = session;
        this.uri = URI.create("mbus://localhost/" + session.name());
        session.setMessageHandler(this);
        this.sessionReference = session.refer((Object)this);
    }

    public void start() {
        log.log(Level.FINE, "Starting message bus server.");
        this.session.connect();
        this.runState.set(State.RUNNING);
    }

    public void close() {
        log.log(Level.FINE, "Closing message bus server.");
        this.runState.set(State.STOPPED);
    }

    protected void destroy() {
        log.log(Level.FINE, "Destroying message bus server.");
        this.runState.set(State.STOPPED);
        this.sessionReference.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(Message msg) {
        State state = this.runState.get();
        if (state == State.INITIALIZING) {
            this.dispatchErrorReply(msg, 100005, "MBusServer not started.");
            return;
        }
        if (state == State.STOPPED) {
            this.dispatchErrorReply(msg, 100005, "MBusServer has been closed.");
            return;
        }
        if (msg.getTrace().shouldTrace(6)) {
            msg.getTrace().trace(6, "Message received by MbusServer.");
        }
        MbusRequest request = null;
        ContentChannel content = null;
        try {
            request = new MbusRequest(this.container, this.uri, msg);
            content = request.connect(new ServerResponseHandler(msg));
        }
        catch (RuntimeException e) {
            this.dispatchErrorReply(msg, 250000, e.toString());
        }
        finally {
            if (request != null) {
                request.release();
            }
        }
        if (content != null) {
            content.close((CompletionHandler)IgnoredCompletionHandler.INSTANCE);
        }
    }

    public String connectionSpec() {
        return this.session.connectionSpec();
    }

    private void dispatchErrorReply(Message msg, int errCode, String errMsg) {
        EmptyReply reply = new EmptyReply();
        reply.swapState((Routable)msg);
        reply.addError(new Error(errCode, errMsg));
        this.session.sendReply((Reply)reply);
    }

    private class ServerResponseHandler
    implements ResponseHandler {
        final Message msg;

        ServerResponseHandler(Message msg) {
            this.msg = msg;
        }

        public ContentChannel handleResponse(Response response) {
            Reply reply;
            if (response instanceof MbusResponse) {
                reply = ((MbusResponse)response).getReply();
            } else {
                reply = new EmptyReply();
                reply.swapState((Routable)this.msg);
            }
            Error err = StatusCodes.toMbusError(response.getStatus());
            if (err != null) {
                if (err.isFatal()) {
                    if (!reply.hasFatalErrors()) {
                        reply.addError(err);
                    }
                } else if (!reply.hasErrors()) {
                    reply.addError(err);
                }
            }
            if (reply.getTrace().shouldTrace(6)) {
                reply.getTrace().trace(6, "Sending reply from MbusServer.");
            }
            MbusServer.this.session.sendReply(reply);
            return null;
        }
    }

    private static enum State {
        INITIALIZING,
        RUNNING,
        STOPPED;

    }
}

