/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.jdisc;

import com.google.inject.Inject;
import com.yahoo.jdisc.AbstractResource;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.RequestDeniedException;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.service.ClientProvider;
import com.yahoo.messagebus.EmptyReply;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Routable;
import com.yahoo.messagebus.jdisc.IgnoredCompletionHandler;
import com.yahoo.messagebus.jdisc.MbusRequest;
import com.yahoo.messagebus.jdisc.MbusResponse;
import com.yahoo.messagebus.jdisc.StatusCodes;
import com.yahoo.messagebus.shared.ClientSession;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MbusClient
extends AbstractResource
implements ClientProvider,
ReplyHandler {
    private static final Logger log = Logger.getLogger(MbusClient.class.getName());
    private static final AtomicInteger threadId = new AtomicInteger(0);
    private final BlockingQueue<MbusRequest> queue = new LinkedBlockingQueue<MbusRequest>();
    private final ClientSession session;
    private final Thread thread;
    private volatile boolean done = false;
    private final ResourceReference sessionReference;

    @Inject
    public MbusClient(ClientSession session) {
        this.session = session;
        this.sessionReference = session.refer();
        this.thread = new Thread((Runnable)new SenderTask(), "mbus-client-" + threadId.getAndIncrement());
    }

    public void start() {
        this.thread.start();
    }

    public ContentChannel handleRequest(Request request, ResponseHandler handler) {
        if (!(request instanceof MbusRequest)) {
            throw new RequestDeniedException(request);
        }
        Message msg = ((MbusRequest)request).getMessage();
        msg.getTrace().trace(6, "Request received by MbusClient.");
        msg.pushHandler(null);
        Long timeout = request.timeRemaining(TimeUnit.MILLISECONDS);
        if (timeout != null) {
            msg.setTimeReceivedNow();
            msg.setTimeRemaining(Math.max(1L, timeout));
        }
        msg.setContext((Object)handler);
        msg.pushHandler((ReplyHandler)this);
        this.sendBlocking((MbusRequest)request);
        return null;
    }

    public void handleTimeout(Request request, ResponseHandler handler) {
    }

    protected void destroy() {
        log.log(Level.FINE, "Destroying message bus client.");
        this.sessionReference.close();
        this.done = true;
    }

    public void handleReply(Reply reply) {
        reply.getTrace().trace(6, "Reply received by MbusClient.");
        ResponseHandler handler = (ResponseHandler)reply.getContext();
        reply.popHandler();
        try {
            handler.handleResponse((Response)new MbusResponse(StatusCodes.fromMbusReply(reply), reply)).close((CompletionHandler)IgnoredCompletionHandler.INSTANCE);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Ignoring exception thrown by ResponseHandler.", e);
        }
    }

    private void sendBlocking(MbusRequest request) {
        while (!this.sendMessage(request)) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean sendMessage(MbusRequest request) {
        Error error;
        Long millis = request.timeRemaining(TimeUnit.MILLISECONDS);
        if (millis != null && millis <= 0L) {
            error = new Error(200009, request.getTimeout(TimeUnit.MILLISECONDS) + " millis");
        } else if (request.isCancelled()) {
            error = new Error(250000, "request cancelled");
        } else {
            try {
                error = this.session.sendMessage(request.getMessage()).getError();
            }
            catch (Exception e) {
                error = new Error(200000, e.toString());
            }
        }
        if (error == null) {
            return true;
        }
        if (error.isFatal()) {
            EmptyReply reply = new EmptyReply();
            reply.swapState((Routable)request.getMessage());
            reply.addError(error);
            reply.popHandler().handleReply((Reply)reply);
            return true;
        }
        return false;
    }

    private class SenderTask
    implements Runnable {
        private SenderTask() {
        }

        @Override
        public void run() {
            while (!MbusClient.this.done) {
                try {
                    MbusRequest request = MbusClient.this.queue.poll(100L, TimeUnit.MILLISECONDS);
                    if (request == null) continue;
                    MbusClient.this.sendBlocking(request);
                }
                catch (Exception e) {
                    log.log(Level.WARNING, "Ignoring exception thrown by MbusClient.", e);
                }
            }
        }
    }
}

