/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.jdisc.test;

import com.google.inject.Module;
import com.yahoo.jdisc.application.ContainerBuilder;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.service.CurrentContainer;
import com.yahoo.jdisc.test.TestDriver;
import com.yahoo.messagebus.DestinationSessionParams;
import com.yahoo.messagebus.Error;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageBusParams;
import com.yahoo.messagebus.Protocol;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.jdisc.MbusServer;
import com.yahoo.messagebus.jdisc.test.RemoteClient;
import com.yahoo.messagebus.network.rpc.RPCNetworkParams;
import com.yahoo.messagebus.routing.Route;
import com.yahoo.messagebus.shared.SharedDestinationSession;
import com.yahoo.messagebus.shared.SharedMessageBus;
import com.yahoo.messagebus.test.SimpleProtocol;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;

public class ServerTestDriver {
    private final RemoteClient client;
    private final MbusServer server;
    private final TestDriver driver;

    private ServerTestDriver(RemoteClient client, boolean activateContainer, RequestHandler requestHandler, Protocol protocol, Module ... guiceModules) {
        this.client = client;
        this.driver = TestDriver.newSimpleApplicationInstanceWithoutOsgi((Module[])guiceModules);
        if (activateContainer) {
            ContainerBuilder builder = this.driver.newContainerBuilder();
            if (requestHandler != null) {
                builder.serverBindings().bind("mbus://*/*", (Object)requestHandler);
            }
            this.driver.activateContainer(builder);
        }
        MessageBusParams mbusParams = new MessageBusParams().addProtocol(protocol);
        RPCNetworkParams netParams = new RPCNetworkParams().setSlobrokConfigId(client.slobrokId());
        SharedMessageBus mbus = SharedMessageBus.newInstance(mbusParams, netParams);
        SharedDestinationSession session = mbus.newDestinationSession(new DestinationSessionParams());
        this.server = new MbusServer((CurrentContainer)this.driver, session);
        this.server.start();
        session.release();
        mbus.release();
    }

    public boolean sendMessage(Message msg) {
        msg.setRoute(Route.parse((String)this.server.connectionSpec()));
        msg.getTrace().setLevel(9);
        return this.client.sendMessage(msg).isAccepted();
    }

    public Reply awaitReply() {
        Reply reply = null;
        try {
            reply = this.client.awaitReply(60, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (reply != null) {
            System.out.println(reply.getTrace());
        }
        return reply;
    }

    public Reply awaitSuccess() {
        Reply reply = this.awaitReply();
        if (reply == null || reply.hasErrors()) {
            return null;
        }
        return reply;
    }

    public Reply awaitErrors(Integer ... errCodes) {
        Reply reply = this.awaitReply();
        if (reply == null) {
            return null;
        }
        LinkedList<Integer> lst = new LinkedList<Integer>(Arrays.asList(errCodes));
        int len = reply.getNumErrors();
        for (int i = 0; i < len; ++i) {
            Error err = reply.getError(i);
            System.out.println(err);
            int idx = lst.indexOf(err.getCode());
            if (idx < 0) {
                return null;
            }
            lst.remove(idx);
        }
        if (!lst.isEmpty()) {
            return null;
        }
        return reply;
    }

    public boolean close() {
        this.server.close();
        this.server.release();
        this.client.close();
        return this.driver.close();
    }

    public TestDriver parent() {
        return this.driver;
    }

    public RemoteClient client() {
        return this.client;
    }

    public MbusServer server() {
        return this.server;
    }

    public static ServerTestDriver newInstance(RequestHandler requestHandler, boolean network, Module ... guiceModules) {
        return new ServerTestDriver(RemoteClient.newInstanceWithInternSlobrok(network), true, requestHandler, (Protocol)new SimpleProtocol(), guiceModules);
    }

    public static ServerTestDriver newInstanceWithProtocol(Protocol protocol, RequestHandler requestHandler, boolean network, Module ... guiceModules) {
        return new ServerTestDriver(RemoteClient.newInstanceWithInternSlobrok(network), true, requestHandler, protocol, guiceModules);
    }

    public static ServerTestDriver newInstanceWithExternSlobrok(String slobrokId, RequestHandler requestHandler, boolean network, Module ... guiceModules) {
        return new ServerTestDriver(RemoteClient.newInstanceWithExternSlobrok(slobrokId, network), true, requestHandler, (Protocol)new SimpleProtocol(), guiceModules);
    }

    public static ServerTestDriver newInactiveInstance(boolean network, Module ... guiceModules) {
        return new ServerTestDriver(RemoteClient.newInstanceWithInternSlobrok(network), false, null, (Protocol)new SimpleProtocol(), guiceModules);
    }

    public static ServerTestDriver newInactiveInstanceWithProtocol(Protocol protocol, boolean network, Module ... guiceModules) {
        return new ServerTestDriver(RemoteClient.newInstanceWithProtocolAndInternSlobrok(protocol, network), false, null, protocol, guiceModules);
    }

    public static ServerTestDriver newUnboundInstance(boolean network, Module ... guiceModules) {
        return new ServerTestDriver(RemoteClient.newInstanceWithInternSlobrok(network), true, null, (Protocol)new SimpleProtocol(), guiceModules);
    }
}

