/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.jdisc.test;

import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.slobrok.server.Slobrok;
import com.yahoo.messagebus.DestinationSession;
import com.yahoo.messagebus.DestinationSessionParams;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.MessageBusParams;
import com.yahoo.messagebus.MessageHandler;
import com.yahoo.messagebus.Protocol;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.jdisc.test.MessageQueue;
import com.yahoo.messagebus.network.Identity;
import com.yahoo.messagebus.network.Network;
import com.yahoo.messagebus.network.rpc.RPCNetwork;
import com.yahoo.messagebus.network.rpc.RPCNetworkParams;
import com.yahoo.messagebus.test.SimpleProtocol;
import java.util.concurrent.TimeUnit;

public class RemoteServer {
    private final Slobrok slobrok;
    private final String slobrokId;
    private final MessageBus mbus;
    private final MessageQueue queue = new MessageQueue();
    private final DestinationSession session;

    private RemoteServer(Slobrok slobrok, String slobrokId, Protocol protocol, String identity) {
        this.slobrok = slobrok;
        this.slobrokId = slobrok != null ? slobrok.configId() : slobrokId;
        this.mbus = new MessageBus((Network)new RPCNetwork(new RPCNetworkParams().setSlobrokConfigId(this.slobrokId).setIdentity(new Identity(identity))), new MessageBusParams().addProtocol(protocol));
        this.session = this.mbus.createDestinationSession(new DestinationSessionParams().setMessageHandler((MessageHandler)this.queue));
    }

    public String connectionSpec() {
        return this.session.getConnectionSpec();
    }

    public Message awaitMessage(int timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.awaitMessage(timeout, unit);
    }

    public void ackMessage(Message msg) {
        this.session.acknowledge(msg);
    }

    public void sendReply(Reply reply) {
        this.session.reply(reply);
    }

    public String slobrokId() {
        return this.slobrokId;
    }

    public void close() {
        this.session.destroy();
        this.mbus.destroy();
        if (this.slobrok != null) {
            this.slobrok.stop();
        }
    }

    public static RemoteServer newInstanceWithInternSlobrok() {
        return new RemoteServer(RemoteServer.newSlobrok(), null, (Protocol)new SimpleProtocol(), "remote");
    }

    public static RemoteServer newInstanceWithExternSlobrok(String slobrokId) {
        return new RemoteServer(null, slobrokId, (Protocol)new SimpleProtocol(), "remote");
    }

    public static RemoteServer newInstance(String slobrokId, String identity, Protocol protocol) {
        return new RemoteServer(null, slobrokId, protocol, identity);
    }

    public static RemoteServer newInstanceWithProtocol(Protocol protocol) {
        return new RemoteServer(RemoteServer.newSlobrok(), null, protocol, "remote");
    }

    private static Slobrok newSlobrok() {
        try {
            return new Slobrok();
        }
        catch (ListenFailedException e) {
            throw new IllegalStateException(e);
        }
    }
}

