/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.messagebus.jdisc.test;

import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.slobrok.server.Slobrok;
import com.yahoo.messagebus.Message;
import com.yahoo.messagebus.MessageBus;
import com.yahoo.messagebus.MessageBusParams;
import com.yahoo.messagebus.Protocol;
import com.yahoo.messagebus.Reply;
import com.yahoo.messagebus.ReplyHandler;
import com.yahoo.messagebus.Result;
import com.yahoo.messagebus.SourceSession;
import com.yahoo.messagebus.SourceSessionParams;
import com.yahoo.messagebus.jdisc.test.ReplyQueue;
import com.yahoo.messagebus.network.Network;
import com.yahoo.messagebus.network.local.LocalNetwork;
import com.yahoo.messagebus.network.rpc.RPCNetwork;
import com.yahoo.messagebus.network.rpc.RPCNetworkParams;
import com.yahoo.messagebus.test.SimpleProtocol;
import java.util.concurrent.TimeUnit;

public class RemoteClient {
    private final Slobrok slobrok;
    private final String slobrokId;
    private final MessageBus mbus;
    private final ReplyQueue queue = new ReplyQueue();
    private final SourceSession session;

    private RemoteClient(Slobrok slobrok, String slobrokId, Protocol protocol, boolean network) {
        this.slobrok = slobrok;
        this.slobrokId = slobrok != null ? slobrok.configId() : slobrokId;
        this.mbus = network ? new MessageBus((Network)new RPCNetwork(new RPCNetworkParams().setSlobrokConfigId(this.slobrokId)), new MessageBusParams().addProtocol(protocol)) : new MessageBus((Network)new LocalNetwork(), new MessageBusParams().addProtocol(protocol));
        this.session = this.mbus.createSourceSession(new SourceSessionParams().setThrottlePolicy(null).setReplyHandler((ReplyHandler)this.queue));
    }

    public Result sendMessage(Message msg) {
        return this.session.send(msg);
    }

    public Reply awaitReply(int timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.awaitReply(timeout, unit);
    }

    public String slobrokId() {
        return this.slobrokId;
    }

    public void close() {
        this.session.destroy();
        this.mbus.destroy();
        if (this.slobrok != null) {
            this.slobrok.stop();
        }
    }

    public static RemoteClient newInstanceWithInternSlobrok(boolean network) {
        return new RemoteClient(RemoteClient.newSlobrok(), null, (Protocol)new SimpleProtocol(), network);
    }

    public static RemoteClient newInstanceWithExternSlobrok(String slobrokId, boolean network) {
        return new RemoteClient(null, slobrokId, (Protocol)new SimpleProtocol(), network);
    }

    public static RemoteClient newInstanceWithProtocolAndInternSlobrok(Protocol protocol, boolean network) {
        return new RemoteClient(RemoteClient.newSlobrok(), null, protocol, network);
    }

    private static Slobrok newSlobrok() {
        Slobrok slobrok;
        try {
            slobrok = new Slobrok();
        }
        catch (ListenFailedException e) {
            throw new IllegalStateException(e);
        }
        return slobrok;
    }
}

