/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.llama;

import java.io.File;
import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class LlamaBundleActivator
implements BundleActivator {
    private static final String SKIP_SUFFIX = ".skip";
    private static final String SKIP_VALUE = "true";
    private static final String PATH_PROPNAME = "de.kherud.llama.lib.path";
    private static final Logger log = Logger.getLogger(LlamaBundleActivator.class.getName());

    public void start(BundleContext ctx) {
        log.fine("start bundle");
        String skipAll = LlamaBundleActivator.class.getSimpleName() + SKIP_SUFFIX;
        if (SKIP_VALUE.equals(System.getProperty(skipAll))) {
            log.fine("skip loading of native libraries");
            return;
        }
        if (this.checkFilenames("/dev/nvidia0", "/opt/vespa-deps/lib64/cuda/libllama.so", "/opt/vespa-deps/lib64/cuda/libjllama.so")) {
            System.setProperty(PATH_PROPNAME, "/opt/vespa-deps/lib64/cuda");
        } else if (this.checkFilenames("/opt/vespa-deps/lib64/libllama.so", "/opt/vespa-deps/lib64/libjllama.so")) {
            System.setProperty(PATH_PROPNAME, "/opt/vespa-deps/lib64");
        } else {
            throw new IllegalArgumentException("Cannot find shared libraries");
        }
    }

    public void stop(BundleContext ctx) {
        log.fine("stop bundle");
    }

    private boolean checkFilenames(String ... filenames) {
        for (String fn : filenames) {
            File f = new File(fn);
            if (f.canRead()) continue;
            return false;
        }
        return true;
    }
}

