/*
 * Decompiled with CFR 0.152.
 */
package de.kherud.llama;

import de.kherud.llama.OSInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.LinkedList;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

class LlamaLoader {
    private static boolean extracted = false;

    LlamaLoader() {
    }

    static synchronized void initialize() throws UnsatisfiedLinkError {
        if (!extracted) {
            LlamaLoader.cleanup();
        }
        if ("Mac".equals(OSInfo.getOSName())) {
            String nativeDirName = LlamaLoader.getNativeResourcePath();
            String tempFolder = LlamaLoader.getTempDir().getAbsolutePath();
            System.out.println(nativeDirName);
            Path metalFilePath = LlamaLoader.extractFile(nativeDirName, "ggml-metal.metal", tempFolder, false);
            if (metalFilePath == null) {
                System.err.println("'ggml-metal.metal' not found");
            }
        }
        LlamaLoader.loadNativeLibrary("llama");
        LlamaLoader.loadNativeLibrary("jllama");
        extracted = true;
    }

    private static void cleanup() {
        try (Stream<Path> dirList = Files.list(LlamaLoader.getTempDir().toPath());){
            dirList.filter(LlamaLoader::shouldCleanPath).forEach(LlamaLoader::cleanPath);
        }
        catch (IOException e) {
            System.err.println("Failed to open directory: " + e.getMessage());
        }
    }

    private static boolean shouldCleanPath(Path path) {
        String fileName = path.getFileName().toString();
        return fileName.startsWith("jllama") || fileName.startsWith("llama");
    }

    private static void cleanPath(Path path) {
        try {
            Files.delete(path);
        }
        catch (Exception e) {
            System.err.println("Failed to delete old native lib: " + e.getMessage());
        }
    }

    private static void loadNativeLibrary(String name) {
        String nativeLibPath;
        LinkedList<String> triedPaths = new LinkedList<String>();
        String nativeLibName = System.getProperty("de.kherud.llama.lib.name");
        if (nativeLibName == null) {
            nativeLibName = System.mapLibraryName(name);
        }
        if ((nativeLibPath = System.getProperty("de.kherud.llama.lib.path")) != null) {
            Path path = Paths.get(nativeLibPath, nativeLibName);
            if (LlamaLoader.loadNativeLibrary(path)) {
                return;
            }
            triedPaths.add(nativeLibPath);
        }
        if (OSInfo.isAndroid()) {
            try {
                System.loadLibrary(name);
                return;
            }
            catch (UnsatisfiedLinkError e) {
                triedPaths.add("Directly from .apk/lib");
            }
        }
        if (LlamaLoader.hasNativeLib(nativeLibPath = LlamaLoader.getNativeResourcePath(), nativeLibName)) {
            String tempFolder = LlamaLoader.getTempDir().getAbsolutePath();
            if (LlamaLoader.extractAndLoadLibraryFile(nativeLibPath, nativeLibName, tempFolder)) {
                return;
            }
            triedPaths.add(nativeLibPath);
        }
        String javaLibraryPath = System.getProperty("java.library.path", "");
        for (String ldPath : javaLibraryPath.split(File.pathSeparator)) {
            if (ldPath.isEmpty()) continue;
            Path path = Paths.get(ldPath, nativeLibName);
            if (LlamaLoader.loadNativeLibrary(path)) {
                return;
            }
            triedPaths.add(ldPath);
        }
        throw new UnsatisfiedLinkError(String.format("No native library found for os.name=%s, os.arch=%s, paths=[%s]", OSInfo.getOSName(), OSInfo.getArchName(), String.join((CharSequence)File.pathSeparator, triedPaths)));
    }

    private static boolean loadNativeLibrary(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            return false;
        }
        String absolutePath = path.toAbsolutePath().toString();
        try {
            System.load(absolutePath);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println(e.getMessage());
            System.err.println("Failed to load native library: " + absolutePath + ". osinfo: " + OSInfo.getNativeLibFolderPathForCurrentOS());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Path extractFile(String sourceDirectory, String fileName, String targetDirectory, boolean addUuid) {
        String nativeLibraryFilePath = sourceDirectory + "/" + fileName;
        Path extractedFilePath = Paths.get(targetDirectory, fileName);
        try {
            try (InputStream reader = LlamaLoader.class.getResourceAsStream(nativeLibraryFilePath);){
                if (reader == null) {
                    Path path = null;
                    return path;
                }
                Files.copy(reader, extractedFilePath, StandardCopyOption.REPLACE_EXISTING);
            }
            finally {
                extractedFilePath.toFile().deleteOnExit();
            }
            extractedFilePath.toFile().setReadable(true);
            extractedFilePath.toFile().setWritable(true, true);
            extractedFilePath.toFile().setExecutable(true);
            try (InputStream nativeIn = LlamaLoader.class.getResourceAsStream(nativeLibraryFilePath);
                 InputStream extractedLibIn = Files.newInputStream(extractedFilePath, new OpenOption[0]);){
                if (!LlamaLoader.contentsEquals(nativeIn, extractedLibIn)) {
                    throw new RuntimeException(String.format("Failed to write a native library file at %s", extractedFilePath));
                }
            }
            System.out.println("Extracted '" + fileName + "' to '" + extractedFilePath + "'");
            return extractedFilePath;
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    private static boolean extractAndLoadLibraryFile(String libFolderForCurrentOS, String libraryFileName, String targetFolder) {
        Path path = LlamaLoader.extractFile(libFolderForCurrentOS, libraryFileName, targetFolder, true);
        if (path == null) {
            return false;
        }
        return LlamaLoader.loadNativeLibrary(path);
    }

    private static boolean contentsEquals(InputStream in1, InputStream in2) throws IOException {
        int ch2;
        if (!(in1 instanceof BufferedInputStream)) {
            in1 = new BufferedInputStream(in1);
        }
        if (!(in2 instanceof BufferedInputStream)) {
            in2 = new BufferedInputStream(in2);
        }
        int ch = in1.read();
        while (ch != -1) {
            ch2 = in2.read();
            if (ch != ch2) {
                return false;
            }
            ch = in1.read();
        }
        ch2 = in2.read();
        return ch2 == -1;
    }

    private static File getTempDir() {
        return new File(System.getProperty("de.kherud.llama.tmpdir", System.getProperty("java.io.tmpdir")));
    }

    private static String getNativeResourcePath() {
        String packagePath = LlamaLoader.class.getPackage().getName().replace(".", "/");
        return String.format("/%s/%s", packagePath, OSInfo.getNativeLibFolderPathForCurrentOS());
    }

    private static boolean hasNativeLib(String path, String libraryName) {
        return LlamaLoader.class.getResource(path + "/" + libraryName) != null;
    }
}

