/*
 * Decompiled with CFR 0.152.
 */
package de.kherud.llama;

import java.util.HashMap;
import java.util.Map;

abstract class JsonParameters {
    final Map<String, String> parameters = new HashMap<String, String>();

    JsonParameters() {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        int i = 0;
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            builder.append("\t\"").append(key).append("\": ").append(value);
            if (i++ < this.parameters.size() - 1) {
                builder.append(",");
            }
            builder.append("\n");
        }
        builder.append("}");
        return builder.toString();
    }

    String toJsonString(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder(text.length() + 2);
        char c = '\u0000';
        int len = text.length();
        builder.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = text.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    builder.append('\\');
                    builder.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        builder.append('\\');
                    }
                    builder.append(c);
                    continue block9;
                }
                case '\b': {
                    builder.append("\\b");
                    continue block9;
                }
                case '\t': {
                    builder.append("\\t");
                    continue block9;
                }
                case '\n': {
                    builder.append("\\n");
                    continue block9;
                }
                case '\f': {
                    builder.append("\\f");
                    continue block9;
                }
                case '\r': {
                    builder.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        builder.append("\\u");
                        String hhhh = Integer.toHexString(c);
                        builder.append("0000", 0, 4 - hhhh.length());
                        builder.append(hhhh);
                        continue block9;
                    }
                    builder.append(c);
                }
            }
        }
        builder.append('\"');
        return builder.toString();
    }
}

