/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.metric;

import ai.vespa.metrics.ContainerMetrics;
import com.yahoo.jdisc.Metric;
import com.yahoo.jrt.TransportMetrics;

class JrtMetrics {
    private final TransportMetrics transportMetrics = TransportMetrics.getInstance();
    private final Metric metric;
    private TransportMetrics.Snapshot previousSnapshot = TransportMetrics.Snapshot.EMPTY;

    JrtMetrics(Metric metric) {
        this.metric = metric;
    }

    void emitMetrics() {
        TransportMetrics.Snapshot snapshot = this.transportMetrics.snapshot();
        TransportMetrics.Snapshot changesSincePrevious = snapshot.changesSince(this.previousSnapshot);
        this.increment(ContainerMetrics.JRT_TRANSPORT_TLS_CERTIFICATE_VERIFICATION_FAILURES.baseName(), changesSincePrevious.tlsCertificateVerificationFailures());
        this.increment(ContainerMetrics.JRT_TRANSPORT_PEER_AUTHORIZATION_FAILURES.baseName(), changesSincePrevious.peerAuthorizationFailures());
        this.increment(ContainerMetrics.JRT_TRANSPORT_SERVER_TLS_CONNECTIONS_ESTABLISHED.baseName(), changesSincePrevious.serverTlsConnectionsEstablished());
        this.increment(ContainerMetrics.JRT_TRANSPORT_CLIENT_TLS_CONNECTIONS_ESTABLISHED.baseName(), changesSincePrevious.clientTlsConnectionsEstablished());
        this.increment(ContainerMetrics.JRT_TRANSPORT_CLIENT_UNENCRYPTED_CONNECTIONS_ESTABLISHED.baseName(), changesSincePrevious.serverUnencryptedConnectionsEstablished());
        this.increment(ContainerMetrics.JRT_TRANSPORT_CLIENT_UNENCRYPTED_CONNECTIONS_ESTABLISHED.baseName(), changesSincePrevious.clientUnencryptedConnectionsEstablished());
        this.previousSnapshot = snapshot;
    }

    private void increment(String metricName, long countIncrement) {
        if (countIncrement > 0L) {
            this.metric.add(metricName, (Number)countIncrement, null);
        }
    }
}

