/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.secretstore;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class SecretStoreConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "884b3d8ee880020852adf8618eb6736d";
    public static final String CONFIG_DEF_NAME = "secret-store";
    public static final String CONFIG_DEF_NAMESPACE = "container.jdisc.secretstore";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container.jdisc.secretstore", "groups[].name string", "groups[].region string", "groups[].awsId string", "groups[].role string", "groups[].externalId string", "awsParameterStores[].name string", "awsParameterStores[].region string", "awsParameterStores[].awsId string", "awsParameterStores[].role string", "awsParameterStores[].externalId string"};
    private final InnerNodeVector<Groups> groups;
    private final InnerNodeVector<AwsParameterStores> awsParameterStores;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public SecretStoreConfig(Builder builder) {
        this(builder, true);
    }

    private SecretStoreConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for secret-store must be initialized: " + builder.__uninitialized);
        }
        this.groups = Groups.createVector(builder.groups);
        this.awsParameterStores = AwsParameterStores.createVector(builder.awsParameterStores);
    }

    public List<Groups> groups() {
        return this.groups;
    }

    public Groups groups(int i) {
        return (Groups)((Object)this.groups.get(i));
    }

    public List<AwsParameterStores> awsParameterStores() {
        return this.awsParameterStores;
    }

    public AwsParameterStores awsParameterStores(int i) {
        return (AwsParameterStores)((Object)this.awsParameterStores.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(SecretStoreConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Groups.Builder> groups = new ArrayList<Groups.Builder>();
        public List<AwsParameterStores.Builder> awsParameterStores = new ArrayList<AwsParameterStores.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(SecretStoreConfig config) {
            for (Groups g : config.groups()) {
                this.groups(new Groups.Builder(g));
            }
            for (AwsParameterStores a : config.awsParameterStores()) {
                this.awsParameterStores(new AwsParameterStores.Builder(a));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.groups.isEmpty()) {
                this.groups.addAll(__superior.groups);
            }
            if (!__superior.awsParameterStores.isEmpty()) {
                this.awsParameterStores.addAll(__superior.awsParameterStores);
            }
            return this;
        }

        public Builder groups(Groups.Builder __builder) {
            this.groups.add(__builder);
            return this;
        }

        public Builder groups(Consumer<Groups.Builder> __func) {
            Groups.Builder __inner = new Groups.Builder();
            __func.accept(__inner);
            this.groups.add(__inner);
            return this;
        }

        public Builder groups(List<Groups.Builder> __builders) {
            this.groups = __builders;
            return this;
        }

        public Builder awsParameterStores(AwsParameterStores.Builder __builder) {
            this.awsParameterStores.add(__builder);
            return this;
        }

        public Builder awsParameterStores(Consumer<AwsParameterStores.Builder> __func) {
            AwsParameterStores.Builder __inner = new AwsParameterStores.Builder();
            __func.accept(__inner);
            this.awsParameterStores.add(__inner);
            return this;
        }

        public Builder awsParameterStores(List<AwsParameterStores.Builder> __builders) {
            this.awsParameterStores = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return SecretStoreConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return SecretStoreConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return SecretStoreConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public SecretStoreConfig build() {
            return new SecretStoreConfig(this);
        }
    }

    public static final class Groups
    extends InnerNode {
        private final StringNode name;
        private final StringNode region;
        private final StringNode awsId;
        private final StringNode role;
        private final StringNode externalId;

        public Groups(Builder builder) {
            this(builder, true);
        }

        private Groups(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for secret-store.groups[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.region = builder.region == null ? new StringNode() : new StringNode(builder.region);
            this.awsId = builder.awsId == null ? new StringNode() : new StringNode(builder.awsId);
            this.role = builder.role == null ? new StringNode() : new StringNode(builder.role);
            this.externalId = builder.externalId == null ? new StringNode() : new StringNode(builder.externalId);
        }

        public String name() {
            return this.name.value();
        }

        public String region() {
            return this.region.value();
        }

        public String awsId() {
            return this.awsId.value();
        }

        public String role() {
            return this.role.value();
        }

        public String externalId() {
            return this.externalId.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Groups newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("groups");
            return changes;
        }

        private static InnerNodeVector<Groups> createVector(List<Builder> builders) {
            ArrayList<Groups> elems = new ArrayList<Groups>();
            for (Builder b : builders) {
                elems.add(new Groups(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "region", "awsId", "role", "externalId"));
            private String name = null;
            private String region = null;
            private String awsId = null;
            private String role = null;
            private String externalId = null;

            public Builder() {
            }

            public Builder(Groups config) {
                this.name(config.name());
                this.region(config.region());
                this.awsId(config.awsId());
                this.role(config.role());
                this.externalId(config.externalId());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.region != null) {
                    this.region(__superior.region);
                }
                if (__superior.awsId != null) {
                    this.awsId(__superior.awsId);
                }
                if (__superior.role != null) {
                    this.role(__superior.role);
                }
                if (__superior.externalId != null) {
                    this.externalId(__superior.externalId);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder region(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.region = __value;
                this.__uninitialized.remove("region");
                return this;
            }

            public Builder awsId(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.awsId = __value;
                this.__uninitialized.remove("awsId");
                return this;
            }

            public Builder role(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.role = __value;
                this.__uninitialized.remove("role");
                return this;
            }

            public Builder externalId(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.externalId = __value;
                this.__uninitialized.remove("externalId");
                return this;
            }

            public Groups build() {
                return new Groups(this);
            }
        }
    }

    public static final class AwsParameterStores
    extends InnerNode {
        private final StringNode name;
        private final StringNode region;
        private final StringNode awsId;
        private final StringNode role;
        private final StringNode externalId;

        public AwsParameterStores(Builder builder) {
            this(builder, true);
        }

        private AwsParameterStores(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for secret-store.awsParameterStores[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.region = builder.region == null ? new StringNode() : new StringNode(builder.region);
            this.awsId = builder.awsId == null ? new StringNode() : new StringNode(builder.awsId);
            this.role = builder.role == null ? new StringNode() : new StringNode(builder.role);
            this.externalId = builder.externalId == null ? new StringNode() : new StringNode(builder.externalId);
        }

        public String name() {
            return this.name.value();
        }

        public String region() {
            return this.region.value();
        }

        public String awsId() {
            return this.awsId.value();
        }

        public String role() {
            return this.role.value();
        }

        public String externalId() {
            return this.externalId.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(AwsParameterStores newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("awsParameterStores");
            return changes;
        }

        private static InnerNodeVector<AwsParameterStores> createVector(List<Builder> builders) {
            ArrayList<AwsParameterStores> elems = new ArrayList<AwsParameterStores>();
            for (Builder b : builders) {
                elems.add(new AwsParameterStores(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "region", "awsId", "role", "externalId"));
            private String name = null;
            private String region = null;
            private String awsId = null;
            private String role = null;
            private String externalId = null;

            public Builder() {
            }

            public Builder(AwsParameterStores config) {
                this.name(config.name());
                this.region(config.region());
                this.awsId(config.awsId());
                this.role(config.role());
                this.externalId(config.externalId());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.region != null) {
                    this.region(__superior.region);
                }
                if (__superior.awsId != null) {
                    this.awsId(__superior.awsId);
                }
                if (__superior.role != null) {
                    this.role(__superior.role);
                }
                if (__superior.externalId != null) {
                    this.externalId(__superior.externalId);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder region(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.region = __value;
                this.__uninitialized.remove("region");
                return this;
            }

            public Builder awsId(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.awsId = __value;
                this.__uninitialized.remove("awsId");
                return this;
            }

            public Builder role(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.role = __value;
                this.__uninitialized.remove("role");
                return this;
            }

            public Builder externalId(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.externalId = __value;
                this.__uninitialized.remove("externalId");
                return this;
            }

            public AwsParameterStores build() {
                return new AwsParameterStores(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

