/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.model;

import java.util.logging.Logger;

public enum SecretVersionState {
    PENDING("PENDING", "Pending"),
    CURRENT("CURRENT", "Current"),
    PREVIOUS("PREVIOUS", "Previous"),
    DEPRECATED("DEPRECATED", "Deprecated");

    private static final Logger log;
    private final String serializedName;
    private final String prettyName;

    private SecretVersionState(String serializedName, String prettyName) {
        this.serializedName = serializedName;
        this.prettyName = prettyName;
    }

    public String serialize() {
        return this.serializedName;
    }

    public String prettyName() {
        return this.prettyName;
    }

    public String toString() {
        return SecretVersionState.class.getSimpleName() + "." + this.serializedName;
    }

    public static SecretVersionState deserialize(String serializedName) {
        for (SecretVersionState state : SecretVersionState.values()) {
            if (!state.serializedName.equals(serializedName)) continue;
            return state;
        }
        throw new IllegalArgumentException("No such secret version state: " + serializedName);
    }

    public void validateTransition(SecretVersionState newState) {
        if (this == newState) {
            log.fine("Transition to the same state: " + String.valueOf((Object)newState));
            return;
        }
        if (this == PREVIOUS && newState != DEPRECATED) {
            throw new IllegalArgumentException("Cannot transition from PREVIOUS state to " + String.valueOf((Object)newState));
        }
        if (this == DEPRECATED) {
            throw new IllegalArgumentException("Cannot transition from DEPRECATED state: " + String.valueOf((Object)this));
        }
        if (newState == PENDING) {
            throw new IllegalArgumentException("Cannot transition to PENDING state: " + String.valueOf((Object)this) + " -> " + String.valueOf((Object)newState));
        }
    }

    static {
        log = Logger.getLogger(SecretVersionState.class.getName());
    }
}

