/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.model;

import ai.vespa.secret.model.Key;
import ai.vespa.secret.model.SecretName;
import ai.vespa.secret.model.SecretValue;
import ai.vespa.secret.model.SecretVersionId;
import ai.vespa.secret.model.SecretVersionState;
import ai.vespa.secret.model.VaultName;
import ai.vespa.validation.StringWrapper;
import com.yahoo.text.Utf8;
import java.util.Arrays;
import java.util.Objects;

public class Secret
implements Comparable<Secret> {
    private final Key key;
    private final byte[] secret;
    private final SecretVersionId version;
    private final SecretVersionState state;

    public Secret(Key key, byte[] secret, SecretVersionId version) {
        this(key, secret, version, SecretVersionState.CURRENT);
    }

    public Secret(Key key, byte[] secret, SecretVersionId version, SecretVersionState state) {
        this.key = key;
        this.secret = secret;
        this.version = version;
        this.state = state;
    }

    public VaultName vaultName() {
        return this.key.vaultName();
    }

    public SecretName secretName() {
        return this.key.secretName();
    }

    public byte[] secret() {
        return this.secret;
    }

    public SecretValue secretValue() {
        return SecretValue.of(this.secretAsString());
    }

    public String secretAsString() {
        return Utf8.toString((byte[])this.secret);
    }

    public SecretVersionId version() {
        return this.version;
    }

    public SecretVersionState state() {
        return this.state;
    }

    public static Key key(VaultName vaultName, SecretName secretName) {
        return new Key(vaultName, secretName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Secret that = (Secret)o;
        if (!that.key.equals(this.key)) {
            return false;
        }
        if (!Arrays.equals(that.secret, this.secret)) {
            return false;
        }
        return that.version.equals(this.version);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.version, Arrays.hashCode(this.secret));
    }

    public String toString() {
        return "Secret{key=" + String.valueOf(this.key) + ", version=" + String.valueOf(this.version) + ", state=" + String.valueOf((Object)this.state) + ", secret=<omitted>}";
    }

    @Override
    public int compareTo(Secret o) {
        int v = this.key.vaultName().compareTo((StringWrapper)o.key.vaultName());
        if (v != 0) {
            return v;
        }
        int n = this.key.secretName().compareTo((StringWrapper)o.key.secretName());
        if (n != 0) {
            return n;
        }
        int s = this.state.compareTo(o.state);
        if (s != 0) {
            return s;
        }
        return o.version.value().compareTo(this.version.value());
    }
}

