/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.model;

import ai.vespa.secret.model.VaultName;

public enum Role {
    READER("reader"),
    WRITER("writer"),
    TENANT_SECRET_WRITER("tenant-secret-updater");

    private final String value;

    private Role(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public String forVault(VaultName vault) {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case WRITER, READER -> vault.value() + "-" + this.value;
            case TENANT_SECRET_WRITER -> this.value;
        };
    }

    public String toString() {
        return Role.class.getSimpleName() + "." + this.value;
    }
}

