/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.container.http.filter.FilterChainRepository;
import com.yahoo.jdisc.http.ServerConfig;
import com.yahoo.jdisc.http.filter.RequestFilter;
import com.yahoo.jdisc.http.filter.ResponseFilter;
import com.yahoo.jdisc.http.filter.SecurityRequestFilter;
import com.yahoo.jdisc.http.filter.SecurityRequestFilterChain;
import com.yahoo.jdisc.http.server.jetty.FilterBindings;
import java.util.HashSet;
import java.util.List;

public class FilterBindingsProvider
implements Provider<FilterBindings> {
    private static final ComponentId SEARCH_SERVER_COMPONENT_ID = ComponentId.fromString((String)"SearchServer");
    private final FilterBindings filterBindings;

    @Inject
    public FilterBindingsProvider(ComponentId componentId, ServerConfig config, FilterChainRepository filterChainRepository, ComponentRegistry<SecurityRequestFilter> legacyRequestFilters) {
        try {
            FilterBindings.Builder builder = new FilterBindings.Builder();
            FilterBindingsProvider.configureLegacyFilters(builder, componentId, legacyRequestFilters);
            FilterBindingsProvider.configureFilters(builder, config, filterChainRepository);
            this.filterBindings = builder.build();
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid config for http server '" + componentId.getNamespace() + "': " + e.getMessage(), e);
        }
    }

    private static void configureLegacyFilters(FilterBindings.Builder builder, ComponentId id, ComponentRegistry<SecurityRequestFilter> legacyRequestFilters) {
        ComponentId serverName = id.getNamespace();
        if (SEARCH_SERVER_COMPONENT_ID.equals((Object)serverName) && !legacyRequestFilters.allComponents().isEmpty()) {
            String filterId = "legacy-filters";
            builder.addRequestFilter(filterId, SecurityRequestFilterChain.newInstance((List)legacyRequestFilters.allComponents()));
            builder.addRequestFilterBinding(filterId, "http://*/*");
        }
    }

    private static void configureFilters(FilterBindings.Builder builder, ServerConfig config, FilterChainRepository filterRepository) {
        FilterBindingsProvider.addFilterInstances(builder, config, filterRepository);
        FilterBindingsProvider.addFilterBindings(builder, config, filterRepository);
        FilterBindingsProvider.addPortDefaultFilters(builder, config, filterRepository);
    }

    private static void addFilterInstances(FilterBindings.Builder builder, ServerConfig config, FilterChainRepository filterRepository) {
        HashSet filterIds = new HashSet();
        config.filter().forEach(filterBinding -> filterIds.add(filterBinding.id()));
        config.defaultFilters().forEach(defaultFilter -> filterIds.add(defaultFilter.filterId()));
        for (String filterId : filterIds) {
            Object filterInstance = FilterBindingsProvider.getFilterInstance(filterRepository, filterId);
            if (filterInstance instanceof RequestFilter && filterInstance instanceof ResponseFilter) {
                throw new IllegalArgumentException("The filter " + filterInstance.getClass().getName() + " is unsupported since it's both a RequestFilter and a ResponseFilter.");
            }
            if (filterInstance instanceof RequestFilter) {
                builder.addRequestFilter(filterId, (RequestFilter)filterInstance);
                continue;
            }
            if (filterInstance instanceof ResponseFilter) {
                builder.addResponseFilter(filterId, (ResponseFilter)filterInstance);
                continue;
            }
            if (filterInstance == null) {
                throw new IllegalArgumentException("No http filter with id " + filterId);
            }
            throw new IllegalArgumentException("Unknown filter type: " + filterInstance.getClass().getName());
        }
    }

    private static void addFilterBindings(FilterBindings.Builder builder, ServerConfig config, FilterChainRepository filterRepository) {
        for (ServerConfig.Filter filterBinding : config.filter()) {
            if (FilterBindingsProvider.isRequestFilter(filterRepository, filterBinding.id())) {
                builder.addRequestFilterBinding(filterBinding.id(), filterBinding.binding());
                continue;
            }
            builder.addResponseFilterBinding(filterBinding.id(), filterBinding.binding());
        }
    }

    private static void addPortDefaultFilters(FilterBindings.Builder builder, ServerConfig config, FilterChainRepository filterRepository) {
        for (ServerConfig.DefaultFilters defaultFilter : config.defaultFilters()) {
            if (FilterBindingsProvider.isRequestFilter(filterRepository, defaultFilter.filterId())) {
                builder.setRequestFilterDefaultForPort(defaultFilter.filterId(), defaultFilter.localPort());
                continue;
            }
            builder.setResponseFilterDefaultForPort(defaultFilter.filterId(), defaultFilter.localPort());
        }
    }

    private static boolean isRequestFilter(FilterChainRepository filterRepository, String filterId) {
        return FilterBindingsProvider.getFilterInstance(filterRepository, filterId) instanceof RequestFilter;
    }

    private static Object getFilterInstance(FilterChainRepository filterRepository, String filterId) {
        return filterRepository.getFilter(ComponentSpecification.fromString((String)filterId));
    }

    public FilterBindings get() {
        return this.filterBindings;
    }

    public void deconstruct() {
    }
}

