/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.yahoo.cloud.config.DataplaneProxyConfig;
import com.yahoo.component.AbstractComponent;
import com.yahoo.jdisc.http.server.jetty.DataplaneProxyCredentials;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;

public class DataplaneProxyService
extends AbstractComponent {
    private static final String PREFIX = "/opt/vespa";
    private static final Path CONFIG_TEMPLATE = Paths.get("/opt/vespa", "conf/nginx/nginx.conf.template");
    private static final Path clientCertificateFile = Paths.get("/opt/vespa", "conf/nginx/client_cert.pem");
    private static final Path clientKeyFile = Paths.get("/opt/vespa", "conf/nginx/client_key.pem");
    private static final Path serverCertificateFile = Paths.get("/opt/vespa", "conf/nginx/server_cert.pem");
    private static final Path serverKeyFile = Paths.get("/opt/vespa", "conf/nginx/server_key.pem");
    private static final Path nginxConf = Paths.get("/opt/vespa", "conf/nginx/nginx.conf");
    private boolean started = false;

    @Inject
    public DataplaneProxyService() {
    }

    public void reconfigure(DataplaneProxyConfig config, DataplaneProxyCredentials credentialsProvider) {
        try {
            String serverCert = config.serverCertificate();
            String serverKey = config.serverKey();
            boolean configChanged = false;
            configChanged |= this.writeFile(serverCertificateFile, serverCert);
            configChanged |= this.writeFile(serverKeyFile, serverKey);
            configChanged |= this.writeFile(nginxConf, DataplaneProxyService.nginxConfig(credentialsProvider.certificateFile(), credentialsProvider.keyFile(), serverCertificateFile, serverKeyFile, config.port(), PREFIX));
            if (!this.started) {
                this.startNginx();
                this.started = true;
            } else if (configChanged) {
                this.reloadNginx();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reconfiguring data plane proxy", e);
        }
    }

    private void startNginx() {
        try {
            Process startCommand = new ProcessBuilder(new String[0]).command("nginx", "-c", nginxConf.toString()).start();
            int exitCode = startCommand.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException("Non-zero exitcode from nginx: %d".formatted(exitCode));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Could not start nginx", e);
        }
    }

    private void reloadNginx() {
        try {
            Process reloadCommand = new ProcessBuilder(new String[0]).command("nginx", "-s", "reload").start();
            int exitCode = reloadCommand.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException("Non-zero exitcode from nginx: %d".formatted(exitCode));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Could not start nginx", e);
        }
    }

    private void stopNginx() {
        try {
            Process stopCommand = new ProcessBuilder(new String[0]).command("nginx", "-s", "reload").start();
            int exitCode = stopCommand.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException("Non-zero exitcode from nginx: %d".formatted(exitCode));
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Could not start nginx", e);
        }
    }

    public void deconstruct() {
        super.deconstruct();
        this.stopNginx();
    }

    private boolean writeFile(Path file, String contents) throws IOException {
        Path tempPath = Paths.get(file.toFile().getAbsolutePath() + ".new", new String[0]);
        Files.createDirectories(tempPath.getParent(), new FileAttribute[0]);
        Files.writeString(tempPath, (CharSequence)contents, new OpenOption[0]);
        if (!Files.exists(file, new LinkOption[0]) || Files.mismatch(tempPath, file) > 0L) {
            Files.move(tempPath, file, StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        Files.delete(tempPath);
        return false;
    }

    static String nginxConfig(Path clientCert, Path clientKey, Path serverCert, Path serverKey, int vespaPort, String prefix) {
        try {
            String nginxTemplate = Files.readString(CONFIG_TEMPLATE);
            nginxTemplate = DataplaneProxyService.replace(nginxTemplate, "client_cert", clientCert.toString());
            nginxTemplate = DataplaneProxyService.replace(nginxTemplate, "client_key", clientKey.toString());
            nginxTemplate = DataplaneProxyService.replace(nginxTemplate, "server_cert", serverCert.toString());
            nginxTemplate = DataplaneProxyService.replace(nginxTemplate, "server_key", serverKey.toString());
            nginxTemplate = DataplaneProxyService.replace(nginxTemplate, "vespa_port", Integer.toString(vespaPort));
            nginxTemplate = DataplaneProxyService.replace(nginxTemplate, "prefix", prefix);
            return nginxTemplate;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not create data plane proxy configuration", e);
        }
    }

    private static String replace(String template, String key, String value) {
        return template.replaceAll("\\$\\{%s\\}".formatted(key), value);
    }
}

