/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.usability;

import com.google.inject.Inject;
import com.yahoo.component.ComponentId;
import com.yahoo.container.Container;
import com.yahoo.container.jdisc.JdiscBindingsConfig;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.FastContentWriter;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.handler.ResponseDispatch;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpRequest;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class BindingsOverviewHandler
extends AbstractRequestHandler {
    private final JdiscBindingsConfig bindingsConfig;

    @Inject
    public BindingsOverviewHandler(JdiscBindingsConfig bindingsConfig) {
        this.bindingsConfig = bindingsConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentChannel handleRequest(Request request, ResponseHandler handler) {
        int statusToReturn;
        JSONObject json;
        if (request instanceof HttpRequest && ((HttpRequest)request).getMethod() != HttpRequest.Method.GET) {
            json = this.errorMessageInJson();
            statusToReturn = 405;
        } else {
            json = new StatusResponse(this.bindingsConfig).render();
            statusToReturn = 200;
        }
        try (FastContentWriter writer = new FastContentWriter(new ResponseDispatch(){

            protected Response newResponse() {
                Response response = new Response(statusToReturn);
                response.headers().add("Content-Type", Arrays.asList("application/json"));
                return response;
            }
        }.connect(handler));){
            writer.write(json.toString());
        }
        return new IgnoredContent();
    }

    private JSONObject errorMessageInJson() {
        JSONObject error = new JSONObject();
        try {
            error.put("error", (Object)("This API, " + ((Object)((Object)this)).getClass().getSimpleName() + ", only supports HTTP GET. You are probably looking for another API/path."));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return error;
    }

    static JSONArray renderRequestHandlers(JdiscBindingsConfig bindingsConfig, Map<ComponentId, ? extends RequestHandler> handlersById) {
        JSONArray ret = new JSONArray();
        for (Map.Entry<ComponentId, ? extends RequestHandler> handlerEntry : handlersById.entrySet()) {
            String id = handlerEntry.getKey().stringValue();
            RequestHandler handler = handlerEntry.getValue();
            JSONObject handlerJson = BindingsOverviewHandler.renderComponent(handler, handlerEntry.getKey());
            BindingsOverviewHandler.addBindings(bindingsConfig, id, handlerJson);
            ret.put((Object)handlerJson);
        }
        return ret;
    }

    private static void addBindings(JdiscBindingsConfig bindingsConfig, String id, JSONObject handlerJson) {
        ArrayList<String> serverBindings = new ArrayList();
        JdiscBindingsConfig.Handlers handlerConfig = bindingsConfig.handlers(id);
        if (handlerConfig != null) {
            serverBindings = handlerConfig.serverBindings();
        }
        BindingsOverviewHandler.putJson(handlerJson, "serverBindings", BindingsOverviewHandler.renderBindings(serverBindings));
    }

    private static JSONArray renderBindings(List<String> bindings) {
        JSONArray ret = new JSONArray();
        for (String binding : bindings) {
            ret.put((Object)binding);
        }
        return ret;
    }

    private static JSONObject renderComponent(Object component, ComponentId id) {
        JSONObject jc = new JSONObject();
        BindingsOverviewHandler.putJson(jc, "id", id.stringValue());
        BindingsOverviewHandler.addBundleInfo(jc, component);
        return jc;
    }

    private static void addBundleInfo(JSONObject jsonObject, Object component) {
        BundleInfo bundleInfo = BindingsOverviewHandler.bundleInfo(component);
        BindingsOverviewHandler.putJson(jsonObject, "class", bundleInfo.className);
        BindingsOverviewHandler.putJson(jsonObject, "bundle", bundleInfo.bundleName);
    }

    private static BundleInfo bundleInfo(Object component) {
        try {
            Bundle bundle = FrameworkUtil.getBundle(component.getClass());
            String bundleName = bundle != null ? bundle.getSymbolicName() + ":" + bundle.getVersion() : "From classpath";
            return new BundleInfo(component.getClass().getName(), bundleName);
        }
        catch (Exception | NoClassDefFoundError e) {
            return new BundleInfo("Unavailable, reconfiguration in progress.", "");
        }
    }

    private static void putJson(JSONObject json, String key, Object value) {
        try {
            json.put(key, value);
        }
        catch (JSONException e) {
            throw new RuntimeException("Trying to add invalid JSON object with key '" + key + "' and value '" + value + "' - " + e.getMessage(), e);
        }
    }

    private class IgnoredContent
    implements ContentChannel {
        private IgnoredContent() {
        }

        public void write(ByteBuffer buf, CompletionHandler handler) {
            handler.completed();
        }

        public void close(CompletionHandler handler) {
            handler.completed();
        }
    }

    static final class StatusResponse {
        private final JdiscBindingsConfig bindingsConfig;

        StatusResponse(JdiscBindingsConfig bindingsConfig) {
            this.bindingsConfig = bindingsConfig;
        }

        public JSONObject render() {
            JSONObject root = new JSONObject();
            BindingsOverviewHandler.putJson(root, "handlers", BindingsOverviewHandler.renderRequestHandlers(this.bindingsConfig, Container.get().getRequestHandlerRegistry().allComponentsById()));
            return root;
        }
    }

    static final class BundleInfo {
        public final String className;
        public final String bundleName;

        BundleInfo(String className, String bundleName) {
            this.className = className;
            this.bundleName = bundleName;
        }
    }
}

