/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.google.common.util.concurrent.AtomicDouble;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.yahoo.cloud.config.SlobroksConfig;
import com.yahoo.collections.CollectionUtil;
import com.yahoo.component.Vtag;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.config.subscription.SubscriberClosedException;
import com.yahoo.container.Container;
import com.yahoo.container.QrConfig;
import com.yahoo.container.core.ChainsConfig;
import com.yahoo.container.core.config.HandlersConfigurerDi;
import com.yahoo.container.di.CloudSubscriberFactory;
import com.yahoo.container.di.ComponentDeconstructor;
import com.yahoo.container.di.config.Subscriber;
import com.yahoo.container.di.config.SubscriberFactory;
import com.yahoo.container.http.filter.FilterChainRepository;
import com.yahoo.container.jdisc.DisableOsgiFramework;
import com.yahoo.container.jdisc.JdiscBindingsConfig;
import com.yahoo.container.jdisc.RestrictedBundleContext;
import com.yahoo.container.jdisc.ShutdownDeadline;
import com.yahoo.container.jdisc.component.Deconstructor;
import com.yahoo.container.jdisc.metric.DisableGuiceMetric;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.Timer;
import com.yahoo.jdisc.application.Application;
import com.yahoo.jdisc.application.BindingRepository;
import com.yahoo.jdisc.application.ContainerActivator;
import com.yahoo.jdisc.application.ContainerBuilder;
import com.yahoo.jdisc.application.DeactivatedContainer;
import com.yahoo.jdisc.application.GuiceRepository;
import com.yahoo.jdisc.application.OsgiFramework;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.service.ClientProvider;
import com.yahoo.jdisc.service.ServerProvider;
import com.yahoo.jrt.Acceptor;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.jrt.Method;
import com.yahoo.jrt.Request;
import com.yahoo.jrt.Spec;
import com.yahoo.jrt.Supervisor;
import com.yahoo.jrt.Transport;
import com.yahoo.jrt.slobrok.api.Register;
import com.yahoo.jrt.slobrok.api.SlobrokList;
import com.yahoo.log.LogSetup;
import com.yahoo.messagebus.network.rpc.SlobrokConfigSubscriber;
import com.yahoo.net.HostName;
import com.yahoo.protect.Process;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.yolean.Exceptions;
import com.yahoo.yolean.UncheckedInterruptedException;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class ConfiguredApplication
implements Application {
    private static final Logger log = Logger.getLogger(ConfiguredApplication.class.getName());
    private final Object monitor = new Object();
    private final Set<ClientProvider> startedClients = ConfiguredApplication.createIdentityHashSet();
    private final Set<ServerProvider> startedServers = ConfiguredApplication.createIdentityHashSet();
    private final SubscriberFactory subscriberFactory;
    private final Metric metric;
    private final ContainerActivator activator;
    private final String configId;
    private final OsgiFramework osgiFramework;
    private final Timer timerSingleton;
    private final AtomicBoolean dumpHeapOnShutdownTimeout = new AtomicBoolean(false);
    private final AtomicDouble shutdownTimeoutS = new AtomicDouble(50.0);
    private final Optional<SlobrokConfigSubscriber> slobrokConfigSubscriber;
    private final ShutdownDeadline shutdownDeadline;
    private final FilterChainRepository defaultFilterChainRepository = new FilterChainRepository(new ChainsConfig(new ChainsConfig.Builder()), new ComponentRegistry(), new ComponentRegistry(), new ComponentRegistry(), new ComponentRegistry());
    private final OsgiFramework restrictedOsgiFramework;
    private final Phaser nonTerminatedContainerTracker = new Phaser(1);
    private final Thread reconfigurerThread;
    private final Thread portWatcher;
    private HandlersConfigurerDi configurer;
    private QrConfig qrConfig;
    private Register slobrokRegistrator = null;
    private Supervisor supervisor = null;
    private Acceptor acceptor = null;
    private volatile boolean shutdownReconfiguration = false;

    private static void installBouncyCastleSecurityProvider() {
        BouncyCastleProvider bcProvider = new BouncyCastleProvider();
        if (Security.addProvider((Provider)bcProvider) != -1) {
            log.info("Installed '" + bcProvider.getInfo() + "' as Java Security Provider");
        } else {
            Provider alreadyInstalledBcProvider = Security.getProvider("BC");
            log.warning("Unable to install '" + bcProvider.getInfo() + "' as Java Security Provider. A provider '" + alreadyInstalledBcProvider.getInfo() + "' is already installed.");
        }
    }

    public static void ensureVespaLoggingInitialized() {
    }

    @Inject
    public ConfiguredApplication(ContainerActivator activator, OsgiFramework osgiFramework, Timer timer, SubscriberFactory subscriberFactory, Metric metric) {
        this.activator = activator;
        this.osgiFramework = osgiFramework;
        this.timerSingleton = timer;
        this.subscriberFactory = subscriberFactory;
        this.metric = metric;
        this.configId = System.getProperty("config.id");
        this.slobrokConfigSubscriber = subscriberFactory instanceof CloudSubscriberFactory ? Optional.of(new SlobrokConfigSubscriber(this.configId)) : Optional.empty();
        this.restrictedOsgiFramework = new DisableOsgiFramework(new RestrictedBundleContext(osgiFramework.bundleContext()));
        this.shutdownDeadline = new ShutdownDeadline(this.configId);
        this.reconfigurerThread = new Thread(this::doReconfigurationLoop, "configured-application-reconfigurer");
        this.portWatcher = new Thread(this::watchPortChange, "configured-application-port-watcher");
    }

    public void start() {
        this.qrConfig = this.getConfig(QrConfig.class, true);
        this.reconfigure(this.qrConfig);
        ConfiguredApplication.hackToInitializeServer(this.qrConfig);
        ContainerBuilder builder = this.createBuilderWithGuiceBindings();
        this.configurer = this.createConfigurer(builder.guiceModules().activate());
        this.initializeAndActivateContainer(builder, () -> {});
        this.reconfigurerThread.setDaemon(true);
        this.reconfigurerThread.start();
        this.portWatcher.setDaemon(true);
        this.portWatcher.start();
        if (this.setupRpc()) {
            this.slobrokRegistrator = this.registerInSlobrok(this.qrConfig);
        }
    }

    private boolean setupRpc() {
        if (!this.qrConfig.rpc().enabled()) {
            return false;
        }
        this.supervisor = new Supervisor(new Transport("configured-application")).setDropEmptyBuffers(true);
        this.supervisor.addMethod(new Method("prepareStop", "d", "", this::prepareStop));
        Spec listenSpec = new Spec(this.qrConfig.rpc().port());
        try {
            this.acceptor = this.supervisor.listen(listenSpec);
            return true;
        }
        catch (ListenFailedException e) {
            throw new RuntimeException("Could not create rpc server listening on " + listenSpec, e);
        }
    }

    private Register registerInSlobrok(QrConfig qrConfig) {
        SlobrokList slobrokList = this.getSlobrokList();
        Spec mySpec = new Spec(HostName.getLocalhost(), this.acceptor.port());
        Register slobrokRegistrator = new Register(this.supervisor, slobrokList, mySpec);
        slobrokRegistrator.registerName(qrConfig.rpc().slobrokId());
        log.log(Level.INFO, "Registered name '" + qrConfig.rpc().slobrokId() + "' at " + mySpec + " with: " + slobrokList);
        return slobrokRegistrator;
    }

    private SlobrokList getSlobrokList() {
        SlobrokList slobrokList;
        if (this.slobrokConfigSubscriber.isPresent()) {
            slobrokList = this.slobrokConfigSubscriber.get().getSlobroks();
        } else {
            slobrokList = new SlobrokList();
            SlobroksConfig slobrokConfig = this.getConfig(SlobroksConfig.class, true);
            slobrokList.setup((String[])slobrokConfig.slobrok().stream().map(SlobroksConfig.Slobrok::connectionspec).toArray(String[]::new));
        }
        return slobrokList;
    }

    private void unregisterInSlobrok() {
        if (this.slobrokRegistrator != null) {
            this.slobrokRegistrator.shutdown();
        }
        if (this.acceptor != null) {
            this.acceptor.shutdown().join();
        }
        if (this.supervisor != null) {
            this.supervisor.transport().shutdown().join();
        }
    }

    private static void hackToInitializeServer(QrConfig config) {
        try {
            Container.get().setupFileAcquirer(config.filedistributor());
            Container.get().setupUrlDownloader();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Caught exception when initializing server. Exiting.", e);
            Runtime.getRuntime().halt(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ConfigInstance> T getConfig(Class<T> configClass, boolean isInitializing) {
        try (Subscriber subscriber = this.subscriberFactory.getSubscriber(Collections.singleton(new ConfigKey(configClass, this.configId)), configClass.getName());){
            subscriber.waitNextGeneration(isInitializing);
            ConfigInstance configInstance = (ConfigInstance)configClass.cast(CollectionUtil.first(subscriber.config().values()));
            return (T)configInstance;
        }
    }

    private void watchPortChange() {
        Subscriber subscriber = this.subscriberFactory.getSubscriber(Collections.singleton(new ConfigKey(QrConfig.class, this.configId)), "portWatcher");
        try {
            while (true) {
                subscriber.waitNextGeneration(false);
                QrConfig newConfig = (QrConfig)QrConfig.class.cast(CollectionUtil.first(subscriber.config().values()));
                this.reconfigure(this.qrConfig);
                if (this.qrConfig.rpc().port() != newConfig.rpc().port()) {
                    Process.logAndDie((String)("Rpc port config has changed from " + this.qrConfig.rpc().port() + " to " + newConfig.rpc().port() + ". This we can not handle without a restart so we will just bail out."));
                }
                log.fine("Received new QrConfig :" + newConfig);
            }
        }
        catch (Throwable throwable) {
            subscriber.close();
            throw throwable;
        }
    }

    void reconfigure(QrConfig qrConfig) {
        this.dumpHeapOnShutdownTimeout.set(qrConfig.shutdown().dumpHeapOnTimeout());
        this.shutdownTimeoutS.set(qrConfig.shutdown().timeout());
    }

    private void initializeAndActivateContainer(ContainerBuilder builder, Runnable cleanupTask) {
        ConfiguredApplication.addHandlerBindings(builder, (ComponentRegistry<RequestHandler>)Container.get().getRequestHandlerRegistry(), ((ApplicationContext)this.configurer.getComponent(ApplicationContext.class)).discBindingsConfig);
        List currentServers = Container.get().getServerProviderRegistry().allComponents();
        for (ServerProvider server : currentServers) {
            builder.serverProviders().install(server);
        }
        this.activateContainer(builder, cleanupTask);
        this.startAndStopServers(currentServers);
        this.startAndRemoveClients(Container.get().getClientProviderRegistry().allComponents());
        log.info("Switching to the latest deployed set of configurations and components. Application config generation: " + this.configurer.generation());
        this.metric.set("application_generation", (Number)this.configurer.generation(), this.metric.createContext(Map.of()));
    }

    private void activateContainer(ContainerBuilder builder, Runnable onPreviousContainerTermination) {
        DeactivatedContainer deactivated = this.activator.activateContainer(builder);
        if (deactivated != null) {
            this.nonTerminatedContainerTracker.register();
            deactivated.notifyTermination(() -> {
                try {
                    onPreviousContainerTermination.run();
                }
                finally {
                    this.nonTerminatedContainerTracker.arriveAndDeregister();
                }
            });
        }
    }

    private ContainerBuilder createBuilderWithGuiceBindings() {
        ContainerBuilder builder = this.activator.newContainerBuilder();
        this.setupGuiceBindings(builder.guiceModules());
        return builder;
    }

    private void doReconfigurationLoop() {
        while (!this.shutdownReconfiguration) {
            try {
                ContainerBuilder builder = this.createBuilderWithGuiceBindings();
                Runnable cleanupTask = this.configurer.waitForNextGraphGeneration(builder.guiceModules().activate(), false);
                this.initializeAndActivateContainer(builder, cleanupTask);
            }
            catch (ConfigInterruptedException | SubscriberClosedException | UncheckedInterruptedException e) {
                break;
            }
            catch (Exception | LinkageError e) {
                ConfiguredApplication.tryReportFailedComponentGraphConstructionMetric(this.configurer, e);
                log.log(Level.SEVERE, "Reconfiguration failed, your application package must be fixed, unless this is a JNI reload issue: " + Exceptions.toMessageString((Throwable)e), e);
            }
            catch (Error e) {
                Process.logAndDie((String)"java.lang.Error on reconfiguration: We are probably in a bad state and will terminate", (Throwable)e);
            }
        }
        log.fine("Reconfiguration loop exited");
    }

    private static void tryReportFailedComponentGraphConstructionMetric(HandlersConfigurerDi configurer, Throwable error) {
        try {
            Metric metric = (Metric)configurer.getComponent(Metric.class);
            Metric.Context metricContext = metric.createContext(Map.of("exception", error.getClass().getSimpleName()));
            metric.add("jdisc.application.failed_component_graphs", (Number)1L, metricContext);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Failed to report metric for failed component graph: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAndStopServers(List<ServerProvider> currentServers) {
        Object object = this.monitor;
        synchronized (object) {
            Set<ServerProvider> serversToClose = ConfiguredApplication.createIdentityHashSet(this.startedServers);
            serversToClose.removeAll(currentServers);
            if (serversToClose.size() > 0) {
                log.info(String.format("Closing %d server instances", serversToClose.size()));
                for (ServerProvider server : serversToClose) {
                    server.close();
                    this.startedServers.remove(server);
                }
            }
            for (ServerProvider server : currentServers) {
                if (this.startedServers.contains(server)) continue;
                server.start();
                this.startedServers.add(server);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAndRemoveClients(List<ClientProvider> currentClients) {
        Object object = this.monitor;
        synchronized (object) {
            Set<ClientProvider> clientToRemove = ConfiguredApplication.createIdentityHashSet(this.startedClients);
            clientToRemove.removeAll(currentClients);
            for (ClientProvider client : clientToRemove) {
                this.startedClients.remove(client);
            }
            for (ClientProvider client : currentClients) {
                if (this.startedClients.contains(client)) continue;
                client.start();
                this.startedClients.add(client);
            }
        }
    }

    private HandlersConfigurerDi createConfigurer(Injector discInjector) {
        return new HandlersConfigurerDi(this.subscriberFactory, Container.get(), this.configId, (ComponentDeconstructor)new Deconstructor(), discInjector, this.osgiFramework);
    }

    private void setupGuiceBindings(GuiceRepository modules) {
        modules.install((Module)new AbstractModule(){

            protected void configure() {
                this.bind(Metric.class).to(DisableGuiceMetric.class);
                this.bind(OsgiFramework.class).toInstance((Object)ConfiguredApplication.this.restrictedOsgiFramework);
                this.bind(Timer.class).toInstance((Object)ConfiguredApplication.this.timerSingleton);
                this.bind(FilterChainRepository.class).toInstance((Object)ConfiguredApplication.this.defaultFilterChainRepository);
            }
        });
    }

    public void stop() {
        log.info("Stop: Initiated");
        this.shutdownDeadline.schedule((long)(this.shutdownTimeoutS.get() * 1000.0), this.dumpHeapOnShutdownTimeout.get());
        this.stopServersAndAwaitTermination();
        log.info("Stop: Finished");
    }

    private void prepareStop(Request request) {
        log.info("PrepareStop: Initiated");
        long timeoutMillis = (long)(request.parameters().get(0).asDouble() * 1000.0);
        try (ShutdownDeadline ignored = new ShutdownDeadline(this.configId).schedule(timeoutMillis, this.dumpHeapOnShutdownTimeout.get());){
            this.stopServersAndAwaitTermination();
            log.info("PrepareStop: Finished");
        }
        catch (Exception e) {
            request.setError(111, e.getMessage());
            throw e;
        }
    }

    private void stopServersAndAwaitTermination() {
        this.shutdownReconfigurer();
        this.startAndStopServers(List.of());
        this.startAndRemoveClients(List.of());
        this.activateContainer(null, () -> log.info("Last active container generation has terminated"));
        this.nonTerminatedContainerTracker.arriveAndAwaitAdvance();
    }

    private void shutdownReconfigurer() {
        if (!this.reconfigurerThread.isAlive()) {
            return;
        }
        log.info("Shutting down reconfiguration thread");
        long start = System.currentTimeMillis();
        this.shutdownReconfiguration = true;
        this.configurer.shutdownConfigRetriever();
        try {
            this.reconfigurerThread.join();
            log.info(String.format("Reconfiguration thread shutdown completed in %.3f seconds", (double)(System.currentTimeMillis() - start) / 1000.0));
        }
        catch (InterruptedException e) {
            String message = "Interrupted while waiting for reconfiguration shutdown";
            log.warning(message);
            log.log(Level.FINE, e.getMessage(), e);
            throw new UncheckedInterruptedException(message, true);
        }
    }

    public void destroy() {
        log.info("Destroy: Shutting down container now");
        if (this.configurer != null) {
            this.configurer.shutdown();
        }
        this.slobrokConfigSubscriber.ifPresent(SlobrokConfigSubscriber::shutdown);
        Container.get().shutdown();
        this.unregisterInSlobrok();
        LogSetup.cleanup();
        this.shutdownDeadline.cancel();
        log.info("Destroy: Finished");
    }

    private static void addHandlerBindings(ContainerBuilder builder, ComponentRegistry<RequestHandler> requestHandlerRegistry, JdiscBindingsConfig discBindingsConfig) {
        for (Map.Entry<String, JdiscBindingsConfig.Handlers> handlerEntry : discBindingsConfig.handlers().entrySet()) {
            String id = handlerEntry.getKey();
            JdiscBindingsConfig.Handlers handlerConfig = handlerEntry.getValue();
            RequestHandler handler = (RequestHandler)requestHandlerRegistry.getComponent(id);
            if (handler == null) {
                throw new RuntimeException("Binding configured for non-jdisc request handler " + id);
            }
            ConfiguredApplication.bindUri((BindingRepository<RequestHandler>)builder.serverBindings(), handlerConfig.serverBindings(), handler);
            ConfiguredApplication.bindUri((BindingRepository<RequestHandler>)builder.clientBindings(), handlerConfig.clientBindings(), handler);
        }
    }

    private static void bindUri(BindingRepository<RequestHandler> bindings, List<String> uriPatterns, RequestHandler target) {
        for (String uri : uriPatterns) {
            bindings.bind(uri, (Object)target);
        }
    }

    private static <E> Set<E> createIdentityHashSet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }

    private static <E> Set<E> createIdentityHashSet(Collection<E> items) {
        Set<E> set = ConfiguredApplication.createIdentityHashSet();
        set.addAll(items);
        return set;
    }

    static {
        LogSetup.initVespaLogging((String)"Container");
        log.log(Level.INFO, "Starting jdisc" + (String)(Vtag.currentVersion.isEmpty() ? "" : " at version " + Vtag.currentVersion));
        ConfiguredApplication.installBouncyCastleSecurityProvider();
    }

    public static final class ApplicationContext {
        final JdiscBindingsConfig discBindingsConfig;

        public ApplicationContext(JdiscBindingsConfig discBindingsConfig) {
            this.discBindingsConfig = discBindingsConfig;
        }
    }
}

