/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.component;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.Deconstructable;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.container.di.ComponentDeconstructor;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.jdisc.SharedResource;
import com.yahoo.protect.Process;
import com.yahoo.yolean.UncheckedInterruptedException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class Deconstructor
implements ComponentDeconstructor {
    private static final Logger log = Logger.getLogger(Deconstructor.class.getName());
    private final ExecutorService executor = Executors.newFixedThreadPool(1, ThreadFactoryFactory.getThreadFactory((String)"component-deconstructor"));
    private final Duration shutdownTimeout;

    public Deconstructor(Duration shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    public Deconstructor() {
        this(Duration.ofSeconds(45L));
    }

    public void deconstruct(long generation, List<Object> components, Collection<Bundle> bundles) {
        ArrayList<Deconstructable> destructibleComponents = new ArrayList<Deconstructable>();
        for (Object component : components) {
            if (component instanceof AbstractComponent) {
                AbstractComponent abstractComponent = (AbstractComponent)component;
                if (!abstractComponent.isDeconstructable()) continue;
                destructibleComponents.add((Deconstructable)abstractComponent);
                continue;
            }
            if (component instanceof Provider) {
                destructibleComponents.add((Deconstructable)component);
                continue;
            }
            if (!(component instanceof SharedResource)) continue;
            destructibleComponents.add(new SharedResourceReleaser(component));
        }
        if (!destructibleComponents.isEmpty() || !bundles.isEmpty()) {
            this.executor.execute(new DestructComponentTask(generation, destructibleComponents, bundles));
        }
    }

    public void shutdown() {
        this.executor.shutdown();
        try {
            log.info("Waiting up to " + this.shutdownTimeout.toSeconds() + " seconds for all previous components graphs to deconstruct.");
            if (!this.executor.awaitTermination(this.shutdownTimeout.getSeconds(), TimeUnit.SECONDS)) {
                log.warning("Waiting for deconstruction timed out.");
            }
        }
        catch (InterruptedException e) {
            log.info("Interrupted while waiting for component deconstruction to finish.");
            throw new UncheckedInterruptedException(e, true);
        }
    }

    private static class DestructComponentTask
    implements Runnable {
        private final Random random = new Random(System.nanoTime());
        private final long generation;
        private final Collection<Deconstructable> components;
        private final Collection<Bundle> bundles;

        DestructComponentTask(long generation, Collection<Deconstructable> components, Collection<Bundle> bundles) {
            this.generation = generation;
            this.components = components;
            this.bundles = bundles;
        }

        private Duration getRandomizedShutdownDelay() {
            long seconds = (long)(this.random.nextDouble() * 60.0 * 10.0);
            return Duration.ofSeconds(seconds);
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            log.info(String.format("Starting deconstruction of %d old components from graph generation %d", this.components.size(), this.generation));
            for (Deconstructable component : this.components) {
                log.log(Level.FINE, () -> "Starting deconstruction of " + component);
                try {
                    component.deconstruct();
                    log.log(Level.FINE, () -> "Finished deconstructing of " + component);
                }
                catch (Exception | NoClassDefFoundError e) {
                    log.log(Level.WARNING, "Exception thrown when deconstructing component " + component, e);
                }
                catch (Error e) {
                    try {
                        Duration shutdownDelay = this.getRandomizedShutdownDelay();
                        log.log(Level.SEVERE, "Error when deconstructing component " + component + ". Will sleep for " + shutdownDelay.getSeconds() + " seconds then restart", e);
                        Thread.sleep(shutdownDelay.toMillis());
                    }
                    catch (InterruptedException exception) {
                        log.log(Level.WARNING, "Randomized wait before dying disrupted. Dying now.");
                    }
                    Process.logAndDie((String)("Shutting down due to error when deconstructing component " + component));
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, "Non-error not exception throwable thrown when deconstructing component  " + component, e);
                }
            }
            log.info(String.format("Completed deconstruction in %.3f seconds", (double)(System.currentTimeMillis() - start) / 1000.0));
            for (Bundle bundle : this.bundles) {
                try {
                    log.log(Level.INFO, "Uninstalling bundle " + bundle);
                    bundle.uninstall();
                }
                catch (BundleException e) {
                    log.log(Level.SEVERE, "Could not uninstall bundle " + bundle);
                }
            }
        }
    }

    private static class SharedResourceReleaser
    implements Deconstructable {
        final SharedResource resource;

        private SharedResourceReleaser(Object resource) {
            this.resource = (SharedResource)resource;
        }

        public void deconstruct() {
            this.resource.release();
        }
    }
}

