/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class JdiscBindingsConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "9027e71cea203743f34c82548b6b6662";
    public static final String CONFIG_DEF_NAME = "jdisc-bindings";
    public static final String CONFIG_DEF_NAMESPACE = "container.jdisc";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container.jdisc", "handlers{}.serverBindings[] string", "handlers{}.clientBindings[] string"};
    private final Map<String, Handlers> handlers;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public JdiscBindingsConfig(Builder builder) {
        this(builder, true);
    }

    private JdiscBindingsConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for jdisc-bindings must be initialized: " + builder.__uninitialized);
        }
        this.handlers = Handlers.createMap(builder.handlers);
    }

    public Map<String, Handlers> handlers() {
        return Collections.unmodifiableMap(this.handlers);
    }

    public Handlers handlers(String key) {
        return this.handlers.get(key);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(JdiscBindingsConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Handlers
    extends InnerNode {
        private final LeafNodeVector<String, StringNode> serverBindings;
        private final LeafNodeVector<String, StringNode> clientBindings;

        public Handlers(Builder builder) {
            this(builder, true);
        }

        private Handlers(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for jdisc-bindings.handlers{} must be initialized: " + builder.__uninitialized);
            }
            this.serverBindings = new LeafNodeVector(builder.serverBindings, (LeafNode)new StringNode());
            this.clientBindings = new LeafNodeVector(builder.clientBindings, (LeafNode)new StringNode());
        }

        public List<String> serverBindings() {
            return this.serverBindings.asList();
        }

        public String serverBindings(int i) {
            return ((StringNode)this.serverBindings.get(i)).value();
        }

        public List<String> clientBindings() {
            return this.clientBindings.asList();
        }

        public String clientBindings(int i) {
            return ((StringNode)this.clientBindings.get(i)).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Handlers newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("handlers");
            return changes;
        }

        private static Map<String, Handlers> createMap(Map<String, Builder> builders) {
            LinkedHashMap<String, Handlers> ret = new LinkedHashMap<String, Handlers>();
            for (String key : builders.keySet()) {
                ret.put(key, new Handlers(builders.get(key)));
            }
            return Collections.unmodifiableMap(ret);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            public List<String> serverBindings = new ArrayList<String>();
            public List<String> clientBindings = new ArrayList<String>();

            public Builder() {
            }

            public Builder(Handlers config) {
                this.serverBindings(config.serverBindings());
                this.clientBindings(config.clientBindings());
            }

            private Builder override(Builder __superior) {
                if (!__superior.serverBindings.isEmpty()) {
                    this.serverBindings.addAll(__superior.serverBindings);
                }
                if (!__superior.clientBindings.isEmpty()) {
                    this.clientBindings.addAll(__superior.clientBindings);
                }
                return this;
            }

            public Builder serverBindings(String __value) {
                this.serverBindings.add(__value);
                return this;
            }

            public Builder serverBindings(Collection<String> __values) {
                this.serverBindings.addAll(__values);
                return this;
            }

            public Builder clientBindings(String __value) {
                this.clientBindings.add(__value);
                return this;
            }

            public Builder clientBindings(Collection<String> __values) {
                this.clientBindings.addAll(__values);
                return this;
            }

            public Handlers build() {
                return new Handlers(this);
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public Map<String, Handlers.Builder> handlers = new LinkedHashMap<String, Handlers.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(JdiscBindingsConfig config) {
            for (Map.Entry<String, Handlers> __entry : config.handlers().entrySet()) {
                this.handlers(__entry.getKey(), new Handlers.Builder(__entry.getValue()));
            }
        }

        private Builder override(Builder __superior) {
            this.handlers(__superior.handlers);
            return this;
        }

        public Builder handlers(String __key, Handlers.Builder __value) {
            this.handlers.put(__key, __value);
            return this;
        }

        public Builder handlers(Map<String, Handlers.Builder> __values) {
            this.handlers.putAll(__values);
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return JdiscBindingsConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return JdiscBindingsConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return JdiscBindingsConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public JdiscBindingsConfig build() {
            return new JdiscBindingsConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

