/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.component;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.Deconstructable;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.container.di.ComponentDeconstructor;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.jdisc.SharedResource;
import com.yahoo.protect.Process;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class Deconstructor
implements ComponentDeconstructor {
    private static final Logger log = Logger.getLogger(Deconstructor.class.getName());
    private static final Duration RECONFIG_DECONSTRUCT_DELAY = Duration.ofSeconds(60L);
    private static final Duration SHUTDOWN_DECONSTRUCT_TIMEOUT = Duration.ofSeconds(45L);
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2, ThreadFactoryFactory.getThreadFactory((String)"component-deconstructor"));
    private final Mode mode;
    private final Duration delay;

    public Deconstructor(Mode mode) {
        this(mode, mode == Mode.RECONFIG ? RECONFIG_DECONSTRUCT_DELAY : Duration.ZERO);
    }

    Deconstructor(Mode mode, Duration reconfigDeconstructDelay) {
        this.mode = mode;
        this.delay = reconfigDeconstructDelay;
    }

    public void deconstruct(List<Object> components, Collection<Bundle> bundles) {
        ArrayList<Deconstructable> destructibleComponents = new ArrayList<Deconstructable>();
        for (Object component : components) {
            if (component instanceof AbstractComponent) {
                AbstractComponent abstractComponent = (AbstractComponent)component;
                if (!abstractComponent.isDeconstructable()) continue;
                destructibleComponents.add((Deconstructable)abstractComponent);
                continue;
            }
            if (component instanceof Provider) {
                destructibleComponents.add((Deconstructable)component);
                continue;
            }
            if (!(component instanceof SharedResource)) continue;
            log.log(Level.FINE, () -> "Releasing container reference to resource " + component);
            ((SharedResource)component).release();
        }
        if (!destructibleComponents.isEmpty() || !bundles.isEmpty()) {
            ScheduledFuture<?> task = this.executor.schedule(new DestructComponentTask(destructibleComponents, bundles), this.delay.getSeconds(), TimeUnit.SECONDS);
            if (this.mode.equals((Object)Mode.SHUTDOWN)) {
                this.waitFor(task, SHUTDOWN_DECONSTRUCT_TIMEOUT);
            }
        }
    }

    private void waitFor(ScheduledFuture<?> task, Duration timeout) {
        try {
            log.info("Waiting up to " + timeout.toSeconds() + " seconds for all components to deconstruct.");
            task.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            log.info("Interrupted while waiting for component deconstruction to finish.");
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            log.warning("Component deconstruction threw an exception: " + e.getMessage());
        }
        catch (TimeoutException e) {
            log.warning("Component deconstruction timed out.");
        }
    }

    private static class DestructComponentTask
    implements Runnable {
        private final Random random = new Random(System.nanoTime());
        private final Collection<Deconstructable> components;
        private final Collection<Bundle> bundles;

        DestructComponentTask(Collection<Deconstructable> components, Collection<Bundle> bundles) {
            this.components = components;
            this.bundles = bundles;
        }

        private Duration getRandomizedShutdownDelay() {
            long seconds = (long)this.random.nextDouble() * 60L * 10L;
            return Duration.ofSeconds(seconds);
        }

        @Override
        public void run() {
            for (Deconstructable component : this.components) {
                log.log(Level.FINE, () -> "Starting deconstruction of " + component);
                try {
                    component.deconstruct();
                    log.log(Level.FINE, () -> "Finished deconstructing of " + component);
                }
                catch (Exception | NoClassDefFoundError e) {
                    log.log(Level.WARNING, "Exception thrown when deconstructing component " + component, e);
                }
                catch (Error e) {
                    try {
                        Duration shutdownDelay = this.getRandomizedShutdownDelay();
                        log.log(Level.SEVERE, "Error when deconstructing component " + component + ". Will sleep for " + shutdownDelay.getSeconds() + " seconds then restart", e);
                        Thread.sleep(shutdownDelay.toMillis());
                    }
                    catch (InterruptedException exception) {
                        log.log(Level.WARNING, "Randomized wait before dying disrupted. Dying now.");
                    }
                    Process.logAndDie((String)("Shutting down due to error when deconstructing component " + component));
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, "Non-error not exception throwable thrown when deconstructing component  " + component, e);
                }
            }
            for (Bundle bundle : this.bundles) {
                try {
                    log.log(Level.INFO, "Uninstalling bundle " + bundle);
                    bundle.uninstall();
                }
                catch (BundleException e) {
                    log.log(Level.SEVERE, "Could not uninstall bundle " + bundle);
                }
            }
        }
    }

    public static enum Mode {
        RECONFIG,
        SHUTDOWN;

    }
}

