/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.usability;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.inject.Inject;
import com.yahoo.component.ComponentId;
import com.yahoo.container.Container;
import com.yahoo.container.jdisc.JdiscBindingsConfig;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.FastContentWriter;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.handler.ResponseDispatch;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpRequest;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class BindingsOverviewHandler
extends AbstractRequestHandler {
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    private final JdiscBindingsConfig bindingsConfig;

    @Inject
    public BindingsOverviewHandler(JdiscBindingsConfig bindingsConfig) {
        this.bindingsConfig = bindingsConfig;
    }

    public ContentChannel handleRequest(Request request, ResponseHandler handler) {
        int statusToReturn;
        JsonNode json;
        if (request instanceof HttpRequest && ((HttpRequest)request).getMethod() != HttpRequest.Method.GET) {
            json = BindingsOverviewHandler.errorMessageInJson();
            statusToReturn = 405;
        } else {
            json = new StatusResponse(this.bindingsConfig).render();
            statusToReturn = 200;
        }
        try (FastContentWriter writer = new FastContentWriter(new ResponseDispatch(){

            protected Response newResponse() {
                Response response = new Response(statusToReturn);
                response.headers().add("Content-Type", List.of("application/json"));
                return response;
            }
        }.connect(handler));){
            writer.write(jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)json));
        }
        return new IgnoredContent();
    }

    private static JsonNode errorMessageInJson() {
        ObjectNode error = jsonMapper.createObjectNode();
        error.put("error", "This API, " + BindingsOverviewHandler.class.getSimpleName() + ", only supports HTTP GET. You are probably looking for another API/path.");
        return error;
    }

    static ArrayNode renderRequestHandlers(JdiscBindingsConfig bindingsConfig, Map<ComponentId, ? extends RequestHandler> handlersById) {
        ArrayNode ret = jsonMapper.createArrayNode();
        for (Map.Entry<ComponentId, ? extends RequestHandler> handlerEntry : handlersById.entrySet()) {
            String id = handlerEntry.getKey().stringValue();
            RequestHandler handler = handlerEntry.getValue();
            ObjectNode handlerJson = BindingsOverviewHandler.renderComponent(handler, handlerEntry.getKey());
            BindingsOverviewHandler.addBindings(bindingsConfig, id, handlerJson);
            ret.add((JsonNode)handlerJson);
        }
        return ret;
    }

    private static void addBindings(JdiscBindingsConfig bindingsConfig, String id, ObjectNode handlerJson) {
        ArrayList<String> serverBindings = new ArrayList();
        JdiscBindingsConfig.Handlers handlerConfig = bindingsConfig.handlers(id);
        if (handlerConfig != null) {
            serverBindings = handlerConfig.serverBindings();
        }
        handlerJson.set("serverBindings", BindingsOverviewHandler.renderBindings(serverBindings));
    }

    private static JsonNode renderBindings(List<String> bindings) {
        ArrayNode array = jsonMapper.createArrayNode();
        for (String binding : bindings) {
            array.add(binding);
        }
        return array;
    }

    private static ObjectNode renderComponent(Object component, ComponentId id) {
        ObjectNode jc = jsonMapper.createObjectNode();
        jc.put("id", id.stringValue());
        BindingsOverviewHandler.addBundleInfo(jc, component);
        return jc;
    }

    private static void addBundleInfo(ObjectNode jsonObject, Object component) {
        BundleInfo bundleInfo = BindingsOverviewHandler.bundleInfo(component);
        jsonObject.put("class", bundleInfo.className);
        jsonObject.put("bundle", bundleInfo.bundleName);
    }

    private static BundleInfo bundleInfo(Object component) {
        try {
            Bundle bundle = FrameworkUtil.getBundle(component.getClass());
            String bundleName = bundle != null ? bundle.getSymbolicName() + ":" + bundle.getVersion() : "From classpath";
            return new BundleInfo(component.getClass().getName(), bundleName);
        }
        catch (Exception | NoClassDefFoundError e) {
            return new BundleInfo("Unavailable, reconfiguration in progress.", "");
        }
    }

    private static class IgnoredContent
    implements ContentChannel {
        private IgnoredContent() {
        }

        public void write(ByteBuffer buf, CompletionHandler handler) {
            handler.completed();
        }

        public void close(CompletionHandler handler) {
            handler.completed();
        }
    }

    static final class StatusResponse {
        private final JdiscBindingsConfig bindingsConfig;

        StatusResponse(JdiscBindingsConfig bindingsConfig) {
            this.bindingsConfig = bindingsConfig;
        }

        public JsonNode render() {
            ObjectNode root = jsonMapper.createObjectNode();
            root.set("handlers", (JsonNode)BindingsOverviewHandler.renderRequestHandlers(this.bindingsConfig, Container.get().getRequestHandlerRegistry().allComponentsById()));
            return root;
        }
    }

    static final class BundleInfo {
        public final String className;
        public final String bundleName;

        BundleInfo(String className, String bundleName) {
            this.className = className;
            this.bundleName = bundleName;
        }
    }
}

