/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.metric;

import com.google.inject.Inject;
import com.yahoo.component.AbstractComponent;
import com.yahoo.container.jdisc.metric.GarbageCollectionMetrics;
import com.yahoo.container.jdisc.metric.JrtMetrics;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.statistics.ContainerWatchdogMetrics;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.Duration;
import java.util.Timer;
import java.util.TimerTask;

public class MetricUpdater
extends AbstractComponent {
    private static final String FREE_MEMORY_BYTES = "mem.heap.free";
    private static final String USED_MEMORY_BYTES = "mem.heap.used";
    private static final String TOTAL_MEMORY_BYTES = "mem.heap.total";
    private static final String MEMORY_MAPPINGS_COUNT = "jdisc.memory_mappings";
    private static final String OPEN_FILE_DESCRIPTORS = "jdisc.open_file_descriptors";
    private final Scheduler scheduler;

    @Inject
    public MetricUpdater(Metric metric, ContainerWatchdogMetrics containerWatchdogMetrics) {
        this(new TimerScheduler(), metric, containerWatchdogMetrics);
    }

    MetricUpdater(Scheduler scheduler, Metric metric, ContainerWatchdogMetrics containerWatchdogMetrics) {
        this.scheduler = scheduler;
        scheduler.schedule(new UpdaterTask(metric, containerWatchdogMetrics), Duration.ofSeconds(10L));
    }

    public void deconstruct() {
        this.scheduler.cancel();
    }

    private static long count_mappings() {
        long count = 0L;
        try {
            byte[] data;
            Path p = Paths.get("/proc/self/maps", new String[0]);
            if (!p.toFile().exists()) {
                return 0L;
            }
            for (byte b : data = Files.readAllBytes(p)) {
                if (b != 10) continue;
                ++count;
            }
        }
        catch (Exception e) {
            System.err.println("Could not read /proc/self/maps: " + e);
        }
        return count;
    }

    private static long count_open_files() {
        long count = 0L;
        try {
            Path p = Paths.get("/proc/self/fd", new String[0]);
            if (!p.toFile().exists()) {
                return 0L;
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(p);){
                for (Path entry : stream) {
                    ++count;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Could not read /proc/self/fd: " + e);
        }
        return count;
    }

    static interface Scheduler {
        public void schedule(Runnable var1, Duration var2);

        public void cancel();
    }

    private static class TimerScheduler
    implements Scheduler {
        private final Timer timer = new Timer();

        private TimerScheduler() {
        }

        @Override
        public void schedule(final Runnable runnable, Duration frequency) {
            long frequencyMillis = frequency.toMillis();
            this.timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    runnable.run();
                }
            }, frequencyMillis, frequencyMillis);
        }

        @Override
        public void cancel() {
            this.timer.cancel();
        }
    }

    private static class UpdaterTask
    implements Runnable {
        private final Runtime runtime = Runtime.getRuntime();
        private final Metric metric;
        private final ContainerWatchdogMetrics containerWatchdogMetrics;
        private final GarbageCollectionMetrics garbageCollectionMetrics;
        private final JrtMetrics jrtMetrics;

        public UpdaterTask(Metric metric, ContainerWatchdogMetrics containerWatchdogMetrics) {
            this.metric = metric;
            this.containerWatchdogMetrics = containerWatchdogMetrics;
            this.garbageCollectionMetrics = new GarbageCollectionMetrics(Clock.systemUTC());
            this.jrtMetrics = new JrtMetrics(metric);
        }

        @Override
        public void run() {
            long freeMemory = this.runtime.freeMemory();
            long totalMemory = this.runtime.totalMemory();
            long usedMemory = totalMemory - freeMemory;
            this.metric.set(MetricUpdater.FREE_MEMORY_BYTES, (Number)freeMemory, null);
            this.metric.set(MetricUpdater.USED_MEMORY_BYTES, (Number)usedMemory, null);
            this.metric.set(MetricUpdater.TOTAL_MEMORY_BYTES, (Number)totalMemory, null);
            this.metric.set(MetricUpdater.MEMORY_MAPPINGS_COUNT, (Number)MetricUpdater.count_mappings(), null);
            this.metric.set(MetricUpdater.OPEN_FILE_DESCRIPTORS, (Number)MetricUpdater.count_open_files(), null);
            this.containerWatchdogMetrics.emitMetrics(this.metric);
            this.garbageCollectionMetrics.emitMetrics(this.metric);
            this.jrtMetrics.emitMetrics();
        }
    }
}

