/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.metric;

import com.yahoo.jdisc.Metric;
import com.yahoo.jrt.TransportMetrics;

class JrtMetrics {
    private final TransportMetrics transportMetrics = TransportMetrics.getInstance();
    private final Metric metric;
    private TransportMetrics.Snapshot previousSnapshot = TransportMetrics.Snapshot.EMPTY;

    JrtMetrics(Metric metric) {
        this.metric = metric;
    }

    void emitMetrics() {
        TransportMetrics.Snapshot snapshot = this.transportMetrics.snapshot();
        TransportMetrics.Snapshot changesSincePrevious = snapshot.changesSince(this.previousSnapshot);
        this.increment("jrt.transport.tls-certificate-verification-failures", changesSincePrevious.tlsCertificateVerificationFailures());
        this.increment("jrt.transport.peer-authorization-failures", changesSincePrevious.peerAuthorizationFailures());
        this.increment("jrt.transport.server.tls-connections-established", changesSincePrevious.serverTlsConnectionsEstablished());
        this.increment("jrt.transport.client.tls-connections-established", changesSincePrevious.clientTlsConnectionsEstablished());
        this.increment("jrt.transport.server.unencrypted-connections-established", changesSincePrevious.serverUnencryptedConnectionsEstablished());
        this.increment("jrt.transport.client.unencrypted-connections-established", changesSincePrevious.clientUnencryptedConnectionsEstablished());
        this.previousSnapshot = snapshot;
    }

    private void increment(String metricName, long countIncrement) {
        if (countIncrement > 0L) {
            this.metric.add(metricName, (Number)countIncrement, null);
        }
    }
}

