/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.component;

import com.yahoo.component.AbstractComponent;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.container.di.ComponentDeconstructor;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.jdisc.SharedResource;
import com.yahoo.log.LogLevel;
import com.yahoo.protect.Process;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class Deconstructor
implements ComponentDeconstructor {
    private static final Logger log = Logger.getLogger(Deconstructor.class.getName());
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, ThreadFactoryFactory.getThreadFactory((String)"component-deconstructor"));
    private final Duration delay;

    public Deconstructor(boolean delayDeconstruction) {
        this.delay = delayDeconstruction ? Duration.ofSeconds(60L) : Duration.ZERO;
    }

    public void deconstruct(Collection<Object> components, Collection<Bundle> bundles) {
        ArrayList<AbstractComponent> destructibleComponents = new ArrayList<AbstractComponent>();
        for (Object component : components) {
            if (component instanceof AbstractComponent) {
                AbstractComponent abstractComponent = (AbstractComponent)component;
                if (!abstractComponent.isDeconstructable()) continue;
                destructibleComponents.add(abstractComponent);
                continue;
            }
            if (component instanceof Provider) {
                log.info("Starting deconstruction of provider " + component);
                ((Provider)component).deconstruct();
                log.info("Finished deconstruction of provider " + component);
                continue;
            }
            if (!(component instanceof SharedResource)) continue;
            log.info("Releasing container reference to resource " + component);
            ((SharedResource)component).release();
        }
        if (!destructibleComponents.isEmpty()) {
            this.executor.schedule(new DestructComponentTask(destructibleComponents, bundles), this.delay.getSeconds(), TimeUnit.SECONDS);
        }
    }

    private static class DestructComponentTask
    implements Runnable {
        private final Random random = new Random(System.nanoTime());
        private final Collection<AbstractComponent> components;
        private final Collection<Bundle> bundles;

        DestructComponentTask(Collection<AbstractComponent> components, Collection<Bundle> bundles) {
            this.components = components;
            this.bundles = bundles;
        }

        private Duration getRandomizedShutdownDelay() {
            long seconds = (long)this.random.nextDouble() * 60L * 10L;
            return Duration.ofSeconds(seconds);
        }

        @Override
        public void run() {
            for (AbstractComponent component : this.components) {
                log.info("Starting deconstruction of component " + component);
                try {
                    component.deconstruct();
                    log.info("Finished deconstructing of component " + component);
                }
                catch (Exception | NoClassDefFoundError e) {
                    log.log(Level.WARNING, "Exception thrown when deconstructing component " + component, e);
                }
                catch (Error e) {
                    try {
                        Duration shutdownDelay = this.getRandomizedShutdownDelay();
                        log.log((Level)LogLevel.FATAL, "Error when deconstructing component " + component + ". Will sleep for " + shutdownDelay.getSeconds() + " seconds then restart", e);
                        Thread.sleep(shutdownDelay.toMillis());
                    }
                    catch (InterruptedException exception) {
                        log.log(Level.WARNING, "Randomized wait before dying disrupted. Dying now.");
                    }
                    Process.logAndDie((String)("Shutting down due to error when deconstructing component " + component));
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, "Non-error not exception throwable thrown when deconstructing component  " + component, e);
                }
            }
            for (Bundle bundle : this.bundles) {
                try {
                    log.info("Uninstalling bundle " + bundle);
                    bundle.uninstall();
                }
                catch (BundleException e) {
                    log.log(Level.SEVERE, "Could not uninstall bundle " + bundle);
                }
            }
        }
    }
}

