/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.metrics.yamasconsumer.cloud;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.DoubleNode;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class ScoreBoardConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "59f50c4a5987674bf00ff946ff1a22aa";
    public static final String CONFIG_DEF_NAME = "score-board";
    public static final String CONFIG_DEF_NAMESPACE = "jdisc.metrics.yamasconsumer.cloud";
    public static final String CONFIG_DEF_VERSION = "";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=jdisc.metrics.yamasconsumer.cloud", "applicationName string default=\"JDisc\"", "step int default=10", "flushTime int default=10", "histogram[].metric string default=\"\"", "histogram[].flags int default=0", "histogram[].buckets[] double"};
    private final StringNode applicationName;
    private final IntegerNode step;
    private final IntegerNode flushTime;
    private final InnerNodeVector<Histogram> histogram;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public static String getDefVersion() {
        return CONFIG_DEF_VERSION;
    }

    public ScoreBoardConfig(Builder builder) {
        this(builder, true);
    }

    private ScoreBoardConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for score-board must be initialized: " + builder.__uninitialized);
        }
        this.applicationName = builder.applicationName == null ? new StringNode("JDisc") : new StringNode(builder.applicationName);
        this.step = builder.step == null ? new IntegerNode(10) : new IntegerNode(builder.step.intValue());
        this.flushTime = builder.flushTime == null ? new IntegerNode(10) : new IntegerNode(builder.flushTime.intValue());
        this.histogram = Histogram.createVector(builder.histogram);
    }

    public String applicationName() {
        return this.applicationName.value();
    }

    public int step() {
        return this.step.value();
    }

    public int flushTime() {
        return this.flushTime.value();
    }

    public List<Histogram> histogram() {
        return this.histogram;
    }

    public Histogram histogram(int i) {
        return (Histogram)((Object)this.histogram.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ScoreBoardConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Histogram
    extends InnerNode {
        private final StringNode metric;
        private final IntegerNode flags;
        private final LeafNodeVector<Double, DoubleNode> buckets;

        public Histogram(Builder builder) {
            this(builder, true);
        }

        private Histogram(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for score-board.histogram[] must be initialized: " + builder.__uninitialized);
            }
            this.metric = builder.metric == null ? new StringNode(ScoreBoardConfig.CONFIG_DEF_VERSION) : new StringNode(builder.metric);
            this.flags = builder.flags == null ? new IntegerNode(0) : new IntegerNode(builder.flags.intValue());
            this.buckets = new LeafNodeVector(builder.buckets, (LeafNode)new DoubleNode());
        }

        public String metric() {
            return this.metric.value();
        }

        public int flags() {
            return this.flags.value();
        }

        public List<Double> buckets() {
            return this.buckets.asList();
        }

        public double buckets(int i) {
            return ((DoubleNode)this.buckets.get(i)).value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Histogram newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("histogram");
            return changes;
        }

        private static InnerNodeVector<Histogram> createVector(List<Builder> builders) {
            ArrayList<Histogram> elems = new ArrayList<Histogram>();
            for (Builder b : builders) {
                elems.add(new Histogram(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private String metric = null;
            private Integer flags = null;
            public List<Double> buckets = new ArrayList<Double>();

            public Builder() {
            }

            public Builder(Histogram config) {
                this.metric(config.metric());
                this.flags(config.flags());
                this.buckets(config.buckets());
            }

            private Builder override(Builder __superior) {
                if (__superior.metric != null) {
                    this.metric(__superior.metric);
                }
                if (__superior.flags != null) {
                    this.flags(__superior.flags);
                }
                if (!__superior.buckets.isEmpty()) {
                    this.buckets.addAll(__superior.buckets);
                }
                return this;
            }

            public Builder metric(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.metric = __value;
                return this;
            }

            public Builder flags(int __value) {
                this.flags = __value;
                return this;
            }

            private Builder flags(String __value) {
                return this.flags(Integer.valueOf(__value));
            }

            public Builder buckets(Double __value) {
                this.buckets.add(__value);
                return this;
            }

            public Builder buckets(Collection<Double> __values) {
                this.buckets.addAll(__values);
                return this;
            }

            private Builder buckets(String __value) {
                return this.buckets(Double.valueOf(__value));
            }
        }
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        private String applicationName = null;
        private Integer step = null;
        private Integer flushTime = null;
        public List<Histogram.Builder> histogram = new ArrayList<Histogram.Builder>();

        public Builder() {
        }

        public Builder(ScoreBoardConfig config) {
            this.applicationName(config.applicationName());
            this.step(config.step());
            this.flushTime(config.flushTime());
            for (Histogram h : config.histogram()) {
                this.histogram(new Histogram.Builder(h));
            }
        }

        private Builder override(Builder __superior) {
            if (__superior.applicationName != null) {
                this.applicationName(__superior.applicationName);
            }
            if (__superior.step != null) {
                this.step(__superior.step);
            }
            if (__superior.flushTime != null) {
                this.flushTime(__superior.flushTime);
            }
            if (!__superior.histogram.isEmpty()) {
                this.histogram.addAll(__superior.histogram);
            }
            return this;
        }

        public Builder applicationName(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.applicationName = __value;
            return this;
        }

        public Builder step(int __value) {
            this.step = __value;
            return this;
        }

        private Builder step(String __value) {
            return this.step(Integer.valueOf(__value));
        }

        public Builder flushTime(int __value) {
            this.flushTime = __value;
            return this;
        }

        private Builder flushTime(String __value) {
            return this.flushTime(Integer.valueOf(__value));
        }

        public Builder histogram(Histogram.Builder __builder) {
            this.histogram.add(__builder);
            return this;
        }

        public Builder histogram(List<Histogram.Builder> __builders) {
            this.histogram = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ScoreBoardConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ScoreBoardConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ScoreBoardConfig.CONFIG_DEF_NAMESPACE;
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

