/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.component;

import com.yahoo.component.AbstractComponent;
import com.yahoo.concurrent.ThreadFactoryFactory;
import com.yahoo.container.di.ComponentDeconstructor;
import com.yahoo.container.di.componentgraph.Provider;
import com.yahoo.jdisc.SharedResource;
import com.yahoo.log.LogLevel;
import com.yahoo.protect.Process;
import java.security.SecureRandom;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Deconstructor
implements ComponentDeconstructor {
    private static final Logger log = Logger.getLogger(Deconstructor.class.getName());
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, ThreadFactoryFactory.getThreadFactory((String)"deconstructor"));
    private final int delay;

    public Deconstructor(boolean delayDeconstruction) {
        this.delay = delayDeconstruction ? 60 : 0;
    }

    public void deconstruct(Object component) {
        if (component instanceof AbstractComponent) {
            AbstractComponent abstractComponent = (AbstractComponent)component;
            if (abstractComponent.isDeconstructable()) {
                this.executor.schedule(new DestructComponentTask(abstractComponent), (long)this.delay, TimeUnit.SECONDS);
            }
        } else if (component instanceof Provider) {
            log.info("Starting deconstruction of " + component);
            ((Provider)component).deconstruct();
            log.info("Finished deconstructing " + component);
        } else if (component instanceof SharedResource) {
            log.info("Starting deconstruction of " + component);
            ((SharedResource)component).release();
            log.info("Finished deconstructing " + component);
        }
    }

    private static class DestructComponentTask
    implements Runnable {
        private final AbstractComponent component;

        DestructComponentTask(AbstractComponent component) {
            this.component = component;
        }

        private long random() {
            return new SecureRandom().nextLong();
        }

        @Override
        public void run() {
            log.info("Starting deconstruction of " + this.component);
            try {
                this.component.deconstruct();
                log.info("Finished deconstructing " + this.component);
            }
            catch (Exception | NoClassDefFoundError e) {
                log.log(Level.WARNING, "Exception thrown when deconstructing " + this.component, e);
            }
            catch (Error e) {
                try {
                    long randomSleepSeconds = this.random() * 60L * 10L;
                    log.log((Level)LogLevel.FATAL, "Error when deconstructing " + this.component + ". Will sleep for " + randomSleepSeconds + " seconds then restart", e);
                    Thread.sleep(randomSleepSeconds * 1000L);
                }
                catch (InterruptedException exception) {
                    log.log(Level.WARNING, "Randomized wait before dying disrupted. Dying now.");
                }
                Process.logAndDie((String)("Shutting down due to error when deconstructing " + this.component));
            }
            catch (Throwable e) {
                log.log(Level.WARNING, "Non-error not exception throwable thrown when deconstructing " + this.component, e);
            }
        }
    }
}

