/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.google.common.collect.MapMaker;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.yahoo.collections.CollectionUtil;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.concurrent.DaemonThreadFactory;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.container.Container;
import com.yahoo.container.QrConfig;
import com.yahoo.container.core.ChainsConfig;
import com.yahoo.container.core.config.HandlersConfigurerDi;
import com.yahoo.container.di.ComponentDeconstructor;
import com.yahoo.container.di.config.Subscriber;
import com.yahoo.container.di.config.SubscriberFactory;
import com.yahoo.container.http.filter.FilterChainRepository;
import com.yahoo.container.jdisc.ContainerDiscApplication;
import com.yahoo.container.jdisc.DisableOsgiFramework;
import com.yahoo.container.jdisc.JdiscBindingsConfig;
import com.yahoo.container.jdisc.RestrictedBundleContext;
import com.yahoo.container.jdisc.component.Deconstructor;
import com.yahoo.container.jdisc.metric.DisableGuiceMetric;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.Timer;
import com.yahoo.jdisc.application.Application;
import com.yahoo.jdisc.application.BindingRepository;
import com.yahoo.jdisc.application.ContainerActivator;
import com.yahoo.jdisc.application.ContainerBuilder;
import com.yahoo.jdisc.application.GuiceRepository;
import com.yahoo.jdisc.application.OsgiFramework;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.service.ClientProvider;
import com.yahoo.jdisc.service.ServerProvider;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.log.LogLevel;
import com.yahoo.log.LogSetup;
import com.yahoo.osgi.Osgi;
import com.yahoo.osgi.OsgiImpl;
import com.yahoo.protect.Process;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.yolean.Exceptions;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ConfiguredApplication
implements Application {
    private static final Logger log = Logger.getLogger(ConfiguredApplication.class.getName());
    private static final Set<ClientProvider> startedClients = ConfiguredApplication.newWeakIdentitySet();
    private static final Set<ServerProvider> startedServers = Collections.newSetFromMap(new IdentityHashMap());
    private final SubscriberFactory subscriberFactory;
    private final ContainerActivator activator;
    private final String configId;
    private final ContainerDiscApplication applicationWithLegacySetup;
    private final OsgiFramework osgiFramework;
    private final Timer timerSingleton;
    private final FilterChainRepository defaultFilterChainRepository = new FilterChainRepository(new ChainsConfig(new ChainsConfig.Builder()), new ComponentRegistry(), new ComponentRegistry(), new ComponentRegistry(), new ComponentRegistry());
    private final OsgiFramework restrictedOsgiFramework;
    private volatile int applicationSerialNo = 0;
    private HandlersConfigurerDi configurer;
    private ScheduledThreadPoolExecutor shutdownDeadlineExecutor;
    private Thread reconfigurerThread;
    private Thread portWatcher;
    private QrConfig qrConfig;

    public static void ensureVespaLoggingInitialized() {
    }

    @Inject
    public ConfiguredApplication(ContainerActivator activator, OsgiFramework osgiFramework, Timer timer, SubscriberFactory subscriberFactory) throws ListenFailedException {
        this.activator = activator;
        this.osgiFramework = osgiFramework;
        this.timerSingleton = timer;
        this.subscriberFactory = subscriberFactory;
        this.configId = System.getProperty("config.id");
        this.restrictedOsgiFramework = new DisableOsgiFramework(new RestrictedBundleContext(osgiFramework.bundleContext()));
        Container.get().setOsgi((Osgi)new OsgiImpl(osgiFramework));
        this.applicationWithLegacySetup = new ContainerDiscApplication(this.configId);
    }

    public void start() {
        this.qrConfig = this.getConfig(QrConfig.class);
        ContainerDiscApplication.hackToInitializeServer(this.qrConfig);
        ContainerBuilder builder = this.createBuilderWithGuiceBindings();
        this.configureComponents(builder.guiceModules().activate());
        this.intitializeAndActivateContainer(builder);
        this.startReconfigurerThread();
        this.portWatcher = new Thread(this::watchPortChange);
        this.portWatcher.setDaemon(true);
        this.portWatcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ConfigInstance> T getConfig(Class<T> configClass) {
        try (Subscriber subscriber = this.subscriberFactory.getSubscriber(Collections.singleton(new ConfigKey(configClass, this.configId)));){
            subscriber.waitNextGeneration();
            ConfigInstance configInstance = (ConfigInstance)configClass.cast(CollectionUtil.first(subscriber.config().values()));
            return (T)configInstance;
        }
    }

    private void watchPortChange() {
        Subscriber subscriber = this.subscriberFactory.getSubscriber(Collections.singleton(new ConfigKey(QrConfig.class, this.configId)));
        try {
            while (true) {
                subscriber.waitNextGeneration();
                QrConfig newConfig = (QrConfig)QrConfig.class.cast(CollectionUtil.first(subscriber.config().values()));
                if (this.qrConfig.rpc().port() != newConfig.rpc().port()) {
                    Process.logAndDie((String)("Rpc port config has changed from " + this.qrConfig.rpc().port() + " to " + newConfig.rpc().port() + ". This we can not handle without a restart so we will just bail out."));
                }
                log.fine("Received new QrConfig :" + newConfig);
            }
        }
        catch (Throwable throwable) {
            subscriber.close();
            throw throwable;
        }
    }

    private void intitializeAndActivateContainer(ContainerBuilder builder) {
        ConfiguredApplication.addHandlerBindings(builder, (ComponentRegistry<RequestHandler>)Container.get().getRequestHandlerRegistry(), ((ApplicationContext)this.configurer.getComponent(ApplicationContext.class)).discBindingsConfig);
        ConfiguredApplication.installServerProviders(builder);
        this.activator.activateContainer(builder);
        ConfiguredApplication.startClients();
        ConfiguredApplication.startAndStopServers();
        log.info("Switching to the latest deployed set of configurations and components. Application switch number: " + this.applicationSerialNo++);
    }

    private ContainerBuilder createBuilderWithGuiceBindings() {
        ContainerBuilder builder = this.activator.newContainerBuilder();
        this.setupGuiceBindings(builder.guiceModules());
        return builder;
    }

    private void startReconfigurerThread() {
        this.reconfigurerThread = new Thread(() -> {
            while (!Thread.interrupted()) {
                try {
                    ContainerBuilder builder = this.createBuilderWithGuiceBindings();
                    this.configurer.runOnceAndEnsureRegistryHackRun(builder.guiceModules().activate());
                    this.intitializeAndActivateContainer(builder);
                }
                catch (ConfigInterruptedException | InterruptedException e) {
                    break;
                }
                catch (Exception | LinkageError e) {
                    log.log(Level.SEVERE, "Reconfiguration failed, your application package must be fixed, unless this is a JNI reload issue: " + Exceptions.toMessageString((Throwable)e), e);
                }
                catch (Error e) {
                    Process.logAndDie((String)"java.lang.Error on reconfiguration: We are probably in a bad state and will terminate", (Throwable)e);
                }
            }
            log.fine("Shutting down HandlersConfigurerDi");
        });
        this.reconfigurerThread.start();
    }

    private static void installServerProviders(ContainerBuilder builder) {
        List serverProviders = Container.get().getServerProviderRegistry().allComponents();
        for (ServerProvider server : serverProviders) {
            builder.serverProviders().install(server);
        }
    }

    private static void startClients() {
        for (ClientProvider client : Container.get().getClientProviderRegistry().allComponents()) {
            if (startedClients.contains(client)) continue;
            client.start();
            startedClients.add(client);
        }
    }

    private static void startAndStopServers() {
        List currentServers = Container.get().getServerProviderRegistry().allComponents();
        HashSet<ServerProvider> serversToClose = new HashSet<ServerProvider>(startedServers);
        serversToClose.removeAll(currentServers);
        for (ServerProvider server : serversToClose) {
            ConfiguredApplication.closeServer(server);
        }
        for (ServerProvider server : currentServers) {
            if (startedServers.contains(server)) continue;
            server.start();
            startedServers.add(server);
        }
    }

    private static void closeServer(ServerProvider server) {
        server.close();
        startedServers.remove(server);
    }

    private void configureComponents(Injector discInjector) {
        this.configurer = new HandlersConfigurerDi(this.subscriberFactory, Container.get(), this.configId, (ComponentDeconstructor)new Deconstructor(true), discInjector, this.osgiFramework);
    }

    private void setupGuiceBindings(GuiceRepository modules) {
        modules.install((Module)new AbstractModule(){

            protected void configure() {
                this.bind(Metric.class).to(DisableGuiceMetric.class);
                this.bind(OsgiFramework.class).toInstance((Object)ConfiguredApplication.this.restrictedOsgiFramework);
                this.bind(Timer.class).toInstance((Object)ConfiguredApplication.this.timerSingleton);
                this.bind(FilterChainRepository.class).toInstance((Object)ConfiguredApplication.this.defaultFilterChainRepository);
            }
        });
        modules.install((Module)this.applicationWithLegacySetup.getMbusBindings());
    }

    public void stop() {
        this.startShutdownDeadlineExecutor();
        this.shutdownReconfigurerThread();
        this.configurer.shutdown((ComponentDeconstructor)new Deconstructor(false));
        for (ServerProvider server : Container.get().getServerProviderRegistry().allComponents()) {
            if (!startedServers.contains(server)) continue;
            ConfiguredApplication.closeServer(server);
        }
        Container.get().shutdown();
    }

    private void shutdownReconfigurerThread() {
        this.reconfigurerThread.interrupt();
        try {
            while (this.reconfigurerThread.isAlive()) {
                this.reconfigurerThread.interrupt();
                long millis = 200L;
                this.reconfigurerThread.join(millis);
            }
        }
        catch (InterruptedException e) {
            log.info("Interrupted while joining on HandlersConfigurer reconfigure thread.");
            Thread.currentThread().interrupt();
        }
    }

    public void destroy() {
        if (this.shutdownDeadlineExecutor != null) {
            this.shutdownDeadlineExecutor.shutdownNow();
        }
    }

    private void startShutdownDeadlineExecutor() {
        this.shutdownDeadlineExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new DaemonThreadFactory("Shutdown deadline timer"));
        this.shutdownDeadlineExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        long delayMillis = 50000L;
        this.shutdownDeadlineExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                Process.logAndDie((String)"Timed out waiting for application shutdown. Please check that all your request handlers drain their request content channels.", (boolean)true);
            }
        }, delayMillis, TimeUnit.MILLISECONDS);
    }

    private static void addHandlerBindings(ContainerBuilder builder, ComponentRegistry<RequestHandler> requestHandlerRegistry, JdiscBindingsConfig discBindingsConfig) {
        for (Map.Entry<String, JdiscBindingsConfig.Handlers> handlerEntry : discBindingsConfig.handlers().entrySet()) {
            String id = handlerEntry.getKey();
            JdiscBindingsConfig.Handlers handlerConfig = handlerEntry.getValue();
            RequestHandler handler = (RequestHandler)requestHandlerRegistry.getComponent(id);
            if (handler == null) {
                throw new RuntimeException("Binding configured for non-jdisc request handler " + id);
            }
            ConfiguredApplication.bindUri((BindingRepository<RequestHandler>)builder.serverBindings(), handlerConfig.serverBindings(), handler);
            ConfiguredApplication.bindUri((BindingRepository<RequestHandler>)builder.clientBindings(), handlerConfig.clientBindings(), handler);
        }
    }

    private static void bindUri(BindingRepository<RequestHandler> bindings, List<String> uriPatterns, RequestHandler target) {
        for (String uri : uriPatterns) {
            bindings.bind(uri, (Object)target);
        }
    }

    private static <T> Set<T> newWeakIdentitySet() {
        ConcurrentMap weakIdentityHashMap = new MapMaker().weakKeys().makeMap();
        return Collections.newSetFromMap(weakIdentityHashMap);
    }

    static {
        LogSetup.initVespaLogging((String)"Container");
        log.log(LogLevel.INFO, "Starting container");
    }

    public static final class ApplicationContext {
        final JdiscBindingsConfig discBindingsConfig;

        public ApplicationContext(JdiscBindingsConfig discBindingsConfig) {
            this.discBindingsConfig = discBindingsConfig;
        }
    }
}

