/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.athenz.impl;

import com.yahoo.vespa.defaults.Defaults;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.eclipse.jetty.http.HttpStatus;

public class IdentityDocumentService {
    private final URI identityDocumentApiUri;

    public IdentityDocumentService(String loadBalancerName) {
        this.identityDocumentApiUri = IdentityDocumentService.createIdentityDocumentApiUri(loadBalancerName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getSignedIdentityDocument() {
        try (CloseableHttpClient httpClient = IdentityDocumentService.createHttpClient();){
            CloseableHttpResponse idDocResponse = httpClient.execute((HttpUriRequest)new HttpGet(this.identityDocumentApiUri));
            String responseContent = EntityUtils.toString((HttpEntity)idDocResponse.getEntity());
            if (HttpStatus.isSuccess((int)idDocResponse.getStatusLine().getStatusCode())) {
                String string = responseContent;
                return string;
            }
            throw new RuntimeException("Failed to initialize Athenz instance provider: " + idDocResponse.getStatusLine() + ": " + responseContent);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed getting signed identity document", e);
        }
    }

    private static CloseableHttpClient createHttpClient() {
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContextBuilder.build(), SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            return HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static URI createIdentityDocumentApiUri(String loadBalancerName) {
        try {
            return new URIBuilder().setScheme("https").setHost(loadBalancerName).setPort(4443).setPath("/athenz/v1/provider/identity-document").addParameter("hostname", Defaults.getDefaults().vespaHostname()).build();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

