/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.athenz.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.yahoo.container.jdisc.athenz.impl.CryptoUtils;
import java.io.IOException;
import java.security.cert.X509Certificate;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InstanceIdentity {
    @JsonProperty(value="x509Certificate")
    private final X509Certificate x509Certificate;
    @JsonProperty(value="serviceToken")
    private final String serviceToken;

    public InstanceIdentity(@JsonProperty(value="x509Certificate") @JsonDeserialize(using=X509CertificateDeserializer.class) X509Certificate x509Certificate, @JsonProperty(value="serviceToken") String serviceToken) {
        this.x509Certificate = x509Certificate;
        this.serviceToken = serviceToken;
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public String getServiceToken() {
        return this.serviceToken;
    }

    public static class X509CertificateDeserializer
    extends JsonDeserializer<X509Certificate> {
        public X509Certificate deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            return CryptoUtils.parseCertificate(parser.getValueAsString());
        }
    }
}

