/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.athenz.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yahoo.container.jdisc.athenz.impl.InstanceIdentity;
import com.yahoo.container.jdisc.athenz.impl.InstanceRefreshInformation;
import com.yahoo.container.jdisc.athenz.impl.InstanceRegisterInformation;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.eclipse.jetty.http.HttpStatus;

public class AthenzService {
    private static final String INSTANCE_API_PATH = "zts/v1/instance";
    private final ObjectMapper objectMapper = new ObjectMapper();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InstanceIdentity sendInstanceRegisterRequest(InstanceRegisterInformation instanceRegisterInformation, String ztsEndpoint) {
        try (CloseableHttpClient client = HttpClientBuilder.create().build();){
            HttpUriRequest postRequest = RequestBuilder.post().setUri(ztsEndpoint + INSTANCE_API_PATH).setEntity((HttpEntity)this.toJsonStringEntity(instanceRegisterInformation)).build();
            InstanceIdentity instanceIdentity = this.getInstanceIdentity(client, postRequest);
            return instanceIdentity;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InstanceIdentity sendInstanceRefreshRequest(String providerService, String instanceDomain, String instanceServiceName, String instanceId, InstanceRefreshInformation instanceRefreshInformation, String ztsEndpoint, X509Certificate certicate, PrivateKey privateKey) {
        try (CloseableHttpClient client = AthenzService.createHttpClientWithTlsAuth(certicate, privateKey);){
            String uri = String.format("%s/%s/%s/%s/%s", ztsEndpoint + INSTANCE_API_PATH, providerService, instanceDomain, instanceServiceName, instanceId);
            HttpUriRequest postRequest = RequestBuilder.post().setUri(uri).setEntity((HttpEntity)this.toJsonStringEntity(instanceRefreshInformation)).build();
            InstanceIdentity instanceIdentity = this.getInstanceIdentity(client, postRequest);
            return instanceIdentity;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private InstanceIdentity getInstanceIdentity(CloseableHttpClient client, HttpUriRequest postRequest) throws IOException {
        Throwable throwable = null;
        try (CloseableHttpResponse response = client.execute(postRequest);){
            if (HttpStatus.isSuccess((int)response.getStatusLine().getStatusCode())) {
                InstanceIdentity instanceIdentity = (InstanceIdentity)this.objectMapper.readValue(response.getEntity().getContent(), InstanceIdentity.class);
                return instanceIdentity;
            }
            try {
                String message = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new RuntimeException(String.format("Unable to get identity. http code/message: %d/%s", response.getStatusLine().getStatusCode(), message));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private StringEntity toJsonStringEntity(Object value) throws JsonProcessingException {
        return new StringEntity(this.objectMapper.writeValueAsString(value), ContentType.APPLICATION_JSON);
    }

    private static CloseableHttpClient createHttpClientWithTlsAuth(X509Certificate certificate, PrivateKey privateKey) {
        try {
            String dummyPassword = "athenz";
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null);
            keyStore.setKeyEntry("athenz", privateKey, dummyPassword.toCharArray(), new Certificate[]{certificate});
            SSLContext sslContext = new SSLContextBuilder().loadKeyMaterial(keyStore, dummyPassword.toCharArray()).build();
            return HttpClientBuilder.create().setSslcontext(sslContext).build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

