/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.yahoo.container.QrConfig;
import com.yahoo.container.Server;
import com.yahoo.container.jdisc.messagebus.SessionCache;
import com.yahoo.jrt.ListenFailedException;
import com.yahoo.log.LogLevel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ContainerDiscApplication {
    private static final Logger log = Logger.getLogger(ContainerDiscApplication.class.getName());
    private SessionCache sessionCache;

    @Inject
    public ContainerDiscApplication(String configId) throws ListenFailedException {
        this.sessionCache = new SessionCache(configId);
    }

    AbstractModule getMbusBindings() {
        return new AbstractModule(){

            protected void configure() {
                this.bind(SessionCache.class).toInstance((Object)ContainerDiscApplication.this.sessionCache);
            }
        };
    }

    public static void hackToInitializeServer(QrConfig config) {
        try {
            Server.get().initialize(config);
        }
        catch (Exception e) {
            log.log((Level)LogLevel.ERROR, "Caught exception when initializing server. Exiting.", e);
            Runtime.getRuntime().halt(1);
        }
    }
}

