/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.ssl.impl;

import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.SslProvider;
import com.yahoo.security.KeyUtils;
import com.yahoo.security.SslContextBuilder;
import com.yahoo.security.X509CertificateUtils;
import com.yahoo.security.tls.AutoReloadingX509KeyManager;
import com.yahoo.security.tls.TlsContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509ExtendedKeyManager;

public class ConfiguredSslContextFactoryProvider
implements SslProvider {
    private volatile AutoReloadingX509KeyManager keyManager;
    private final ConnectorConfig connectorConfig;

    public ConfiguredSslContextFactoryProvider(ConnectorConfig connectorConfig) {
        ConfiguredSslContextFactoryProvider.validateConfig(connectorConfig.ssl());
        this.connectorConfig = connectorConfig;
    }

    @Override
    public void configureSsl(SslProvider.ConnectorSsl ssl, String name, int port) {
        ConnectorConfig.Ssl sslConfig = this.connectorConfig.ssl();
        if (!sslConfig.enabled()) {
            throw new IllegalStateException();
        }
        SslContextBuilder builder = new SslContextBuilder();
        if (sslConfig.certificateFile().isBlank() || sslConfig.privateKeyFile().isBlank()) {
            PrivateKey privateKey = KeyUtils.fromPemEncodedPrivateKey((String)ConfiguredSslContextFactoryProvider.getPrivateKey(sslConfig));
            List certificates = X509CertificateUtils.certificateListFromPem((String)ConfiguredSslContextFactoryProvider.getCertificate(sslConfig));
            builder.withKeyStore(privateKey, certificates);
        } else {
            this.keyManager = AutoReloadingX509KeyManager.fromPemFiles((Path)Paths.get(sslConfig.privateKeyFile(), new String[0]), (Path)Paths.get(sslConfig.certificateFile(), new String[0]));
            builder.withKeyManager((X509ExtendedKeyManager)this.keyManager);
        }
        List caCertificates = ConfiguredSslContextFactoryProvider.getCaCertificates(sslConfig).map(X509CertificateUtils::certificateListFromPem).orElse(List.of());
        builder.withTrustStore(caCertificates);
        SSLContext sslContext = builder.build();
        ssl.setSslContext(sslContext);
        switch (sslConfig.clientAuth()) {
            case NEED_AUTH: {
                ssl.setClientAuth(SslProvider.ConnectorSsl.ClientAuth.NEED);
                break;
            }
            case WANT_AUTH: {
                ssl.setClientAuth(SslProvider.ConnectorSsl.ClientAuth.WANT);
                break;
            }
            case DISABLED: {
                ssl.setClientAuth(SslProvider.ConnectorSsl.ClientAuth.DISABLED);
                break;
            }
            default: {
                throw new IllegalArgumentException(sslConfig.clientAuth().toString());
            }
        }
        ArrayList<String> protocols = !sslConfig.enabledProtocols().isEmpty() ? sslConfig.enabledProtocols() : new ArrayList<String>(TlsContext.getAllowedProtocols((SSLContext)sslContext));
        ssl.setEnabledProtocolVersions(protocols);
        ArrayList<String> ciphers = !sslConfig.enabledCipherSuites().isEmpty() ? sslConfig.enabledCipherSuites() : new ArrayList<String>(TlsContext.getAllowedCipherSuites((SSLContext)sslContext));
        ssl.setEnabledCipherSuites(ciphers);
    }

    @Override
    public void close() {
        if (this.keyManager != null) {
            this.keyManager.close();
        }
    }

    private static void validateConfig(ConnectorConfig.Ssl config) {
        if (!config.enabled()) {
            return;
        }
        if (ConfiguredSslContextFactoryProvider.hasBoth(config.certificate(), config.certificateFile())) {
            throw new IllegalArgumentException("Specified both certificate and certificate file.");
        }
        if (ConfiguredSslContextFactoryProvider.hasBoth(config.privateKey(), config.privateKeyFile())) {
            throw new IllegalArgumentException("Specified both private key and private key file.");
        }
        if (ConfiguredSslContextFactoryProvider.hasNeither(config.certificate(), config.certificateFile())) {
            throw new IllegalArgumentException("Specified neither certificate or certificate file.");
        }
        if (ConfiguredSslContextFactoryProvider.hasNeither(config.privateKey(), config.privateKeyFile())) {
            throw new IllegalArgumentException("Specified neither private key or private key file.");
        }
    }

    private static boolean hasBoth(String a, String b) {
        return !a.isBlank() && !b.isBlank();
    }

    private static boolean hasNeither(String a, String b) {
        return a.isBlank() && b.isBlank();
    }

    private static Optional<String> getCaCertificates(ConnectorConfig.Ssl sslConfig) {
        if (!sslConfig.caCertificate().isBlank()) {
            return Optional.of(sslConfig.caCertificate());
        }
        if (!sslConfig.caCertificateFile().isBlank()) {
            return Optional.of(ConfiguredSslContextFactoryProvider.readToString(sslConfig.caCertificateFile()));
        }
        return Optional.empty();
    }

    private static String getPrivateKey(ConnectorConfig.Ssl config) {
        if (!config.privateKey().isBlank()) {
            return config.privateKey();
        }
        return ConfiguredSslContextFactoryProvider.readToString(config.privateKeyFile());
    }

    private static String getCertificate(ConnectorConfig.Ssl config) {
        if (!config.certificate().isBlank()) {
            return config.certificate();
        }
        return ConfiguredSslContextFactoryProvider.readToString(config.certificateFile());
    }

    private static String readToString(String filename) {
        try {
            return Files.readString(Paths.get(filename, new String[0]), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

