/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.request;

import com.yahoo.collections.MethodCache;
import com.yahoo.component.provider.FreezableClass;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.processing.request.properties.PublicCloneable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;

public class CloneHelper {
    private static final Logger log = Logger.getLogger(CloneHelper.class.getName());
    private static final MethodCache cloneMethodCache = new MethodCache("clone");

    public final Object clone(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof Cloneable)) {
            return null;
        }
        if (object.getClass().isArray()) {
            return this.arrayClone(object);
        }
        return this.objectClone(object);
    }

    private Object arrayClone(Object array) {
        if (array instanceof Object[]) {
            return this.objectArrayClone((Object[])array);
        }
        if (array instanceof byte[]) {
            return Arrays.copyOf((byte[])array, ((byte[])array).length);
        }
        if (array instanceof char[]) {
            return Arrays.copyOf((char[])array, ((char[])array).length);
        }
        if (array instanceof short[]) {
            return Arrays.copyOf((short[])array, ((short[])array).length);
        }
        if (array instanceof int[]) {
            return Arrays.copyOf((int[])array, ((int[])array).length);
        }
        if (array instanceof long[]) {
            return Arrays.copyOf((long[])array, ((long[])array).length);
        }
        if (array instanceof float[]) {
            return Arrays.copyOf((float[])array, ((float[])array).length);
        }
        if (array instanceof double[]) {
            return Arrays.copyOf((double[])array, ((double[])array).length);
        }
        if (array instanceof boolean[]) {
            return Arrays.copyOf((boolean[])array, ((boolean[])array).length);
        }
        return new IllegalArgumentException("Unexpected primitive array type " + array.getClass());
    }

    private Object objectArrayClone(Object[] object) {
        Object[] arrayClone = Arrays.copyOf(object, object.length);
        for (int i = 0; i < arrayClone.length; ++i) {
            Object elementClone = this.clone(arrayClone[i]);
            if (elementClone == null) continue;
            arrayClone[i] = elementClone;
        }
        return arrayClone;
    }

    protected Object objectClone(Object object) {
        if (object instanceof FreezableClass) {
            return ((FreezableClass)object).clone();
        }
        if (object instanceof com.yahoo.lang.PublicCloneable) {
            return ((com.yahoo.lang.PublicCloneable)object).clone();
        }
        if (object instanceof PublicCloneable) {
            return ((PublicCloneable)object).clone();
        }
        if (object instanceof LinkedList) {
            return ((LinkedList)object).clone();
        }
        if (object instanceof ArrayList) {
            return ((ArrayList)object).clone();
        }
        if (object instanceof HashMap) {
            return ((HashMap)object).clone();
        }
        if (object instanceof HashSet) {
            return ((HashSet)object).clone();
        }
        try {
            return this.cloneByReflection(object);
        }
        catch (IllegalArgumentException e) {
            if (!(e.getCause() instanceof ClassCastException)) {
                throw e;
            }
            cloneMethodCache.clear();
            return this.cloneByReflection(object);
        }
    }

    private Object cloneByReflection(Object object) {
        try {
            Method cloneMethod = cloneMethodCache.get(object);
            if (cloneMethod == null) {
                log.warning("'" + object + "' of class " + object.getClass() + " is Cloneable, but has no clone method - will use the same instance in all requests");
                return null;
            }
            return cloneMethod.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            log.warning("'" + object + "' of class " + object.getClass() + " is Cloneable, but clone method cannot be accessed - will use the same instance in all requests");
            return null;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Exception cloning '" + object + "'", e);
        }
    }

    public Map<CompoundName, Object> cloneMap(Map<CompoundName, Object> map) {
        HashMap<CompoundName, Object> cloneMap = new HashMap<CompoundName, Object>((int)((double)map.size() / 0.75) + 1);
        for (Map.Entry<CompoundName, Object> entry : map.entrySet()) {
            Object cloneValue = this.clone(entry.getValue());
            if (cloneValue == null) {
                cloneValue = entry.getValue();
            }
            cloneMap.put(entry.getKey(), cloneValue);
        }
        return cloneMap;
    }
}

