/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.handler;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.annotation.Inject;
import com.yahoo.component.chain.Chain;
import com.yahoo.component.chain.ChainedComponent;
import com.yahoo.component.chain.ChainsConfigurer;
import com.yahoo.component.chain.model.ChainsModelBuilder;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.container.core.ChainsConfig;
import com.yahoo.container.jdisc.ContentChannelOutputStream;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.HttpResponse;
import com.yahoo.container.jdisc.LoggingRequestHandler;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.container.logging.AccessLog;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.processing.Processor;
import com.yahoo.processing.Request;
import com.yahoo.processing.Response;
import com.yahoo.processing.execution.Execution;
import com.yahoo.processing.execution.ResponseReceiver;
import com.yahoo.processing.execution.chain.ChainRegistry;
import com.yahoo.processing.handler.ProcessingResponse;
import com.yahoo.processing.rendering.AsynchronousSectionedRenderer;
import com.yahoo.processing.rendering.ProcessingRenderer;
import com.yahoo.processing.rendering.Renderer;
import com.yahoo.processing.request.CompoundName;
import com.yahoo.processing.request.ErrorMessage;
import com.yahoo.processing.request.Properties;
import java.util.Map;
import java.util.concurrent.Executor;

public abstract class AbstractProcessingHandler<COMPONENT extends Processor>
extends LoggingRequestHandler {
    private static final CompoundName freezeListenerKey = new CompoundName("processing.freezeListener");
    public static final String DEFAULT_RENDERER_ID = "default";
    private final Executor renderingExecutor;
    private ChainRegistry<COMPONENT> chainRegistry;
    private final ComponentRegistry<Renderer> renderers;
    private final Renderer defaultRenderer;

    public AbstractProcessingHandler(ChainRegistry<COMPONENT> chainRegistry, ComponentRegistry<Renderer> renderers, Executor executor, AccessLog ignored, Metric metric) {
        super(executor, metric, true);
        this.renderingExecutor = executor;
        this.chainRegistry = chainRegistry;
        this.renderers = renderers;
        Renderer defaultRenderer = (Renderer)renderers.getComponent(ComponentSpecification.fromString((String)DEFAULT_RENDERER_ID));
        if (defaultRenderer == null) {
            defaultRenderer = new ProcessingRenderer();
            renderers.register(ComponentId.fromString((String)DEFAULT_RENDERER_ID), (Object)defaultRenderer);
        }
        this.defaultRenderer = defaultRenderer;
    }

    public AbstractProcessingHandler(ChainRegistry<COMPONENT> chainRegistry, ComponentRegistry<Renderer> renderers, Executor executor, AccessLog ignored) {
        this(chainRegistry, renderers, executor, ignored, null);
    }

    public AbstractProcessingHandler(ChainsConfig processingChainsConfig, ComponentRegistry<COMPONENT> chainedComponents, ComponentRegistry<Renderer> renderers, Executor executor, AccessLog ignored) {
        this(processingChainsConfig, chainedComponents, renderers, executor, ignored, null);
    }

    @Inject
    public AbstractProcessingHandler(ChainsConfig processingChainsConfig, ComponentRegistry<COMPONENT> chainedComponents, ComponentRegistry<Renderer> renderers, Executor executor, AccessLog ignored, Metric metric) {
        this(AbstractProcessingHandler.createChainRegistry(processingChainsConfig, chainedComponents), renderers, executor, ignored, metric);
    }

    @Override
    public HttpResponse handle(HttpRequest request) {
        throw new UnsupportedOperationException("Call handle(request, channel) instead");
    }

    @Override
    public HttpResponse handle(HttpRequest request, ContentChannel channel) {
        Request processingRequest = new Request();
        this.populate("", request.propertyMap(), processingRequest.properties());
        this.populate("context", request.getJDiscRequest().context(), processingRequest.properties());
        processingRequest.properties().set(Request.JDISC_REQUEST, (Object)request);
        FreezeListener freezeListener = new FreezeListener(processingRequest, this.renderers, this.defaultRenderer, channel, this.renderingExecutor);
        processingRequest.properties().set(freezeListenerKey, (Object)freezeListener);
        Chain chain = (Chain)this.chainRegistry.getComponent(this.resolveChainId(processingRequest.properties()));
        if (chain == null) {
            throw new IllegalArgumentException("Chain '" + processingRequest.properties().get("chain") + "' not found");
        }
        Execution execution = this.createExecution(chain, processingRequest);
        freezeListener.setExecution(execution);
        Response processingResponse = execution.process(processingRequest);
        return freezeListener.getHttpResponse(processingResponse);
    }

    public Execution createExecution(Chain<COMPONENT> chain, Request processingRequest) {
        int traceLevel = processingRequest.properties().getInteger("tracelevel", (Integer)0);
        return Execution.createRoot(chain, traceLevel, new Execution.Environment<COMPONENT>(this.chainRegistry));
    }

    public ChainRegistry<COMPONENT> getChainRegistry() {
        return this.chainRegistry;
    }

    public ComponentRegistry<Renderer> getRenderers() {
        return this.renderers;
    }

    public Renderer<Response> getRendererCopy(ComponentSpecification spec) {
        Renderer renderer = (Renderer)this.getRenderers().getComponent(spec);
        if (renderer == null) {
            throw new IllegalArgumentException("No renderer with spec: " + spec);
        }
        return AbstractProcessingHandler.perRenderingCopy(renderer);
    }

    private static Renderer<Response> perRenderingCopy(Renderer<Response> renderer) {
        AbstractComponent copy = renderer.clone();
        copy.init();
        return copy;
    }

    private static Renderer selectRenderer(Request processingRequest, ComponentRegistry<Renderer> renderers, Renderer defaultRenderer) {
        Renderer renderer = null;
        String rendererId = processingRequest.properties().getString("format");
        if (rendererId != null && !"".equals(rendererId) && (renderer = (Renderer)renderers.getComponent(ComponentSpecification.fromString((String)rendererId))) == null) {
            processingRequest.errors().add(new ErrorMessage("Could not find renderer", "Requested '" + rendererId + "', has " + renderers.allComponents()));
        }
        if (renderer == null) {
            renderer = defaultRenderer;
        }
        return renderer;
    }

    private static <COMPONENT extends ChainedComponent> ChainRegistry<COMPONENT> createChainRegistry(ChainsConfig processingChainsConfig, ComponentRegistry<COMPONENT> availableComponents) {
        ChainRegistry chainRegistry = new ChainRegistry();
        ChainsConfigurer.prepareChainRegistry(chainRegistry, ChainsModelBuilder.buildFromConfig(processingChainsConfig), availableComponents);
        chainRegistry.freeze();
        return chainRegistry;
    }

    private String resolveChainId(Properties properties) {
        return properties.getString(Request.CHAIN, DEFAULT_RENDERER_ID);
    }

    private void populate(String prefixName, Map<String, ?> parameters, Properties properties) {
        CompoundName prefix = new CompoundName(prefixName);
        for (Map.Entry<String, ?> entry : parameters.entrySet()) {
            properties.set(prefix.append(entry.getKey()), entry.getValue());
        }
    }

    private static class FreezeListener
    implements Runnable,
    ResponseReceiver {
        private final Request request;
        private final ComponentRegistry<Renderer> renderers;
        private final Renderer defaultRenderer;
        private final ContentChannel channel;
        private final Executor renderingExecutor;
        private Execution execution;
        private Response response;
        private Renderer<Response> renderer = null;

        public FreezeListener(Request request, ComponentRegistry<Renderer> renderers, Renderer defaultRenderer, ContentChannel channel, Executor renderingExecutor) {
            this.request = request;
            this.renderers = renderers;
            this.defaultRenderer = defaultRenderer;
            this.channel = channel;
            this.renderingExecutor = renderingExecutor;
        }

        @Override
        public void setResponse(Response response) {
            this.response = response;
        }

        public void setExecution(Execution execution) {
            this.execution = execution;
        }

        public Renderer getRenderer() {
            if (this.renderer == null) {
                this.renderer = AbstractProcessingHandler.perRenderingCopy(AbstractProcessingHandler.selectRenderer(this.request, this.renderers, this.defaultRenderer));
            }
            return this.renderer;
        }

        private HttpResponse getHttpResponse(Response processingResponse) {
            int status = 200;
            return new ProcessingResponse(status, this.request, processingResponse, this.getRenderer(), this.renderingExecutor, this.execution);
        }

        @Override
        public void run() {
            if (this.execution == null || this.response == null) {
                throw new NullPointerException("Uninitialized freeze listener");
            }
            if (this.channel instanceof ThreadedHttpRequestHandler.LazyContentChannel) {
                ((ThreadedHttpRequestHandler.LazyContentChannel)this.channel).setHttpResponse(this.getHttpResponse(this.response));
            }
            if (this.getRenderer() instanceof AsynchronousSectionedRenderer) {
                ((AsynchronousSectionedRenderer)this.getRenderer()).renderResponseBeforeHandover(new ContentChannelOutputStream(this.channel), this.response, this.execution, this.request);
            }
        }
    }
}

