/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.component.chain.dependencies.ordering;

import com.yahoo.component.chain.dependencies.ordering.ComponentNode;
import com.yahoo.component.chain.dependencies.ordering.NameProvider;
import com.yahoo.component.chain.dependencies.ordering.Node;
import com.yahoo.component.chain.dependencies.ordering.OrderedReadyNodes;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;

class ComponentNameProvider
extends NameProvider {
    private Set<ComponentNode> nodes = new LinkedHashSet<ComponentNode>();
    private Logger logger = Logger.getLogger(this.getClass().getName());

    ComponentNameProvider(String name) {
        super(name, 0);
    }

    protected void addNode(ComponentNode componentNode) {
        if (this.nodes.add(componentNode)) {
            componentNode.notifyAfter();
        }
    }

    @Override
    protected void handleRemoved(OrderedReadyNodes readyNodes) {
        for (Node node : this.nodes) {
            for (Node afterThis : this.nodesAfterThis) {
                node.before(afterThis);
            }
            node.beforeRemoved(readyNodes);
        }
    }

    @Override
    int classPriority() {
        return 1;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("components [");
        Iterator<ComponentNode> i = this.nodes.iterator();
        while (i.hasNext()) {
            b.append(i.next().getComponent().getId());
            if (!i.hasNext()) continue;
            b.append(", ");
        }
        b.append("]");
        return b.toString();
    }
}

