/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import com.yahoo.container.logging.AccessLogEntry;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.handler.AbstractRequestHandler;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.jdisc.handler.DelegatedRequestHandler;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.handler.ResponseHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;

public class AccessLoggingRequestHandler
extends AbstractRequestHandler
implements DelegatedRequestHandler {
    public static final String CONTEXT_KEY_ACCESS_LOG_ENTRY = AccessLoggingRequestHandler.class.getName() + "_access-log-entry";
    private final org.eclipse.jetty.server.Request jettyRequest;
    private final RequestHandler delegateRequestHandler;
    private final AccessLogEntry accessLogEntry;

    public static Optional<AccessLogEntry> getAccessLogEntry(HttpRequest jdiscRequest) {
        Map requestContextMap = jdiscRequest.context();
        return AccessLoggingRequestHandler.getAccessLogEntry(requestContextMap);
    }

    public static Optional<AccessLogEntry> getAccessLogEntry(Map<String, Object> requestContextMap) {
        return Optional.ofNullable((AccessLogEntry)requestContextMap.get(CONTEXT_KEY_ACCESS_LOG_ENTRY));
    }

    public AccessLoggingRequestHandler(org.eclipse.jetty.server.Request jettyRequest, RequestHandler delegateRequestHandler, AccessLogEntry accessLogEntry) {
        this.jettyRequest = jettyRequest;
        this.delegateRequestHandler = delegateRequestHandler;
        this.accessLogEntry = accessLogEntry;
    }

    public ContentChannel handleRequest(Request request, ResponseHandler handler) {
        long contentMaxSize;
        HttpRequest httpRequest = (HttpRequest)request;
        httpRequest.context().put(CONTEXT_KEY_ACCESS_LOG_ENTRY, this.accessLogEntry);
        List<HttpRequest.Method> methodsWithEntity = List.of(HttpRequest.Method.POST, HttpRequest.Method.PUT, HttpRequest.Method.PATCH);
        ContentChannel originalContentChannel = this.delegateRequestHandler.handleRequest(request, handler);
        String uriPath = request.getUri().getPath();
        if (methodsWithEntity.contains((Object)httpRequest.getMethod()) && (contentMaxSize = RequestUtils.getConnector(this.jettyRequest).requestContentLogging().stream().filter(rcl -> uriPath.startsWith(rcl.pathPrefix()) && rcl.samplingRate().shouldSample()).map(rcl -> rcl.maxSize()).findAny().orElse(0L).longValue()) > 0L) {
            return new ContentLoggingContentChannel(originalContentChannel, contentMaxSize);
        }
        return originalContentChannel;
    }

    public RequestHandler getDelegate() {
        return this.delegateRequestHandler;
    }

    private class ContentLoggingContentChannel
    implements ContentChannel {
        final AtomicLong length = new AtomicLong();
        final ByteArrayOutputStream accumulatedRequestContent;
        final ContentChannel originalContentChannel;
        final long contentLoggingMaxSize;

        public ContentLoggingContentChannel(ContentChannel originalContentChannel, long contentLoggingMaxSize) {
            this.originalContentChannel = originalContentChannel;
            this.contentLoggingMaxSize = contentLoggingMaxSize;
            long contentLength = AccessLoggingRequestHandler.this.jettyRequest.getLength();
            this.accumulatedRequestContent = new ByteArrayOutputStream(contentLength == -1L ? 128 : Math.toIntExact(contentLength));
        }

        public void write(ByteBuffer buf, CompletionHandler handler) {
            this.length.addAndGet(buf.remaining());
            int bytesToLog = Math.toIntExact(Math.min((long)buf.remaining(), this.contentLoggingMaxSize - (long)this.accumulatedRequestContent.size()));
            if (bytesToLog > 0) {
                if (buf.hasArray()) {
                    this.accumulatedRequestContent.write(buf.array(), buf.arrayOffset() + buf.position(), bytesToLog);
                } else {
                    byte[] temp = new byte[bytesToLog];
                    buf.get(temp);
                    this.accumulatedRequestContent.write(temp, 0, bytesToLog);
                    buf.position(buf.position() - bytesToLog);
                }
            }
            if (this.originalContentChannel != null) {
                this.originalContentChannel.write(buf, handler);
            }
        }

        public void close(CompletionHandler handler) {
            byte[] bytes = this.accumulatedRequestContent.toByteArray();
            AccessLoggingRequestHandler.this.accessLogEntry.setContent(new AccessLogEntry.Content(Objects.requireNonNullElse(AccessLoggingRequestHandler.this.jettyRequest.getHeaders().get("Content-Type"), ""), this.length.get(), bytes));
            this.accumulatedRequestContent.reset();
            this.length.set(0L);
            if (this.originalContentChannel != null) {
                this.originalContentChannel.close(handler);
            }
        }

        public void onError(Throwable error) {
            if (this.originalContentChannel != null) {
                this.originalContentChannel.onError(error);
            }
        }
    }
}

