/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.server.jetty;

import ai.vespa.sampling.ProbabilisticSampleRate;
import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.server.jetty.ConnectionThrottler;
import com.yahoo.jdisc.http.server.jetty.RequestUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ConnectionStatistics;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

class JDiscServerConnector
extends ServerConnector {
    private final Map<MetricContextKey, Metric.Context> requestMetricContexts;
    public static final String REQUEST_ATTRIBUTE = JDiscServerConnector.class.getName();
    private final Metric.Context connectorMetricCtx;
    private final ConnectionStatistics statistics;
    private final ConnectorConfig config;
    private final Metric metric;
    private final String connectorName;
    private final int listenPort;
    private final List<RequestContentLogging> requestContentLogging;

    JDiscServerConnector(ConnectorConfig config, Metric metric, Server server, ConnectionFactory ... factories) {
        super(server, factories);
        this.config = config;
        this.metric = metric;
        this.connectorName = config.name();
        this.listenPort = config.listenPort();
        this.connectorMetricCtx = metric.createContext(JDiscServerConnector.createConnectorDimensions(this.listenPort, this.connectorName, 0));
        this.requestMetricContexts = JDiscServerConnector.createRequestMetricContexts(metric, this.listenPort, this.connectorName);
        this.statistics = new ConnectionStatistics();
        this.setAcceptedTcpNoDelay(config.tcpNoDelay());
        this.addBean(this.statistics);
        ConnectorConfig.Throttling throttlingConfig = config.throttling();
        if (throttlingConfig.enabled()) {
            new ConnectionThrottler((AbstractConnector)this, throttlingConfig).registerWithConnector();
        }
        this.setPort(config.listenPort());
        this.setName(config.name());
        this.setAcceptQueueSize(config.acceptQueueSize());
        this.setReuseAddress(config.reuseAddress());
        long idleTimeout = (long)(config.idleTimeout() * 1000.0);
        this.setIdleTimeout(idleTimeout);
        long shutdownIdleTimeout = (long)(config.shutdownIdleTimeout() * 1000.0);
        this.setShutdownIdleTimeout(Math.min(shutdownIdleTimeout, Math.min(idleTimeout, server.getStopTimeout())));
        this.requestContentLogging = config.accessLog().content().stream().map(e -> new RequestContentLogging(e.pathPrefix(), ProbabilisticSampleRate.withSystemDefaults((double)e.sampleRate()), e.maxSize())).toList();
    }

    List<RequestContentLogging> requestContentLogging() {
        return this.requestContentLogging;
    }

    public ConnectionStatistics getStatistics() {
        return this.statistics;
    }

    public Metric.Context getConnectorMetricContext() {
        return this.connectorMetricCtx;
    }

    Metric.Context createRequestMetricContext(Request request) {
        String protocol;
        String method = request.getMethod();
        Metric.Context requestMetricCtx = this.requestMetricContexts.get(new MetricContextKey(method, protocol = request.getConnectionMetaData().getProtocol()));
        if (requestMetricCtx != null) {
            return requestMetricCtx;
        }
        return JDiscServerConnector.createRequestMetricContext(this.metric, this.listenPort, this.connectorName, method, protocol);
    }

    ConnectorConfig connectorConfig() {
        return this.config;
    }

    int listenPort() {
        return this.listenPort;
    }

    private static Map<String, Object> createConnectorDimensions(int listenPort, String connectorName, int reservedSize) {
        HashMap<String, Object> props = new HashMap<String, Object>(reservedSize + 2);
        props.put("serverName", connectorName);
        props.put("serverPort", listenPort);
        return props;
    }

    static Metric.Context createRequestMetricContext(Metric metric, int listenPort, String connectorName, String method, String protocol) {
        Map<String, Object> dimensions = JDiscServerConnector.createConnectorDimensions(listenPort, connectorName, 2);
        dimensions.put("httpMethod", method);
        dimensions.put("protocol", protocol);
        return metric.createContext(dimensions);
    }

    private static Map<MetricContextKey, Metric.Context> createRequestMetricContexts(Metric metric, int listenPort, String connectorName) {
        HashMap<MetricContextKey, Metric.Context> requestMetricContexts = new HashMap<MetricContextKey, Metric.Context>();
        for (String method : RequestUtils.SUPPORTED_METHODS) {
            for (HttpVersion protocol : HttpVersion.values()) {
                requestMetricContexts.put(new MetricContextKey(method, protocol.asString()), JDiscServerConnector.createRequestMetricContext(metric, listenPort, connectorName, method, protocol.asString()));
            }
        }
        return requestMetricContexts;
    }

    record MetricContextKey(String method, String protocol) {
    }

    record RequestContentLogging(String pathPrefix, ProbabilisticSampleRate samplingRate, long maxSize) {
    }
}

