/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.logging;

public class Coverage {
    private final long docs;
    private final long active;
    private final long targetActive;
    private final int degradedReason;
    private final boolean useTargetActiveForCoverageComputation;
    private static final int DEGRADED_BY_MATCH_PHASE = 1;
    private static final int DEGRADED_BY_TIMEOUT = 2;
    private static final int DEGRADED_BY_ADAPTIVE_TIMEOUT = 4;

    public Coverage(long docs, long active, long targetActive, int degradedReason, boolean useTargetActiveForCoverageComputation) {
        this.docs = docs;
        this.active = active;
        this.targetActive = targetActive;
        this.degradedReason = degradedReason;
        this.useTargetActiveForCoverageComputation = useTargetActiveForCoverageComputation;
    }

    Coverage(long docs, long active, long targetActive, int degradedReason) {
        this(docs, active, targetActive, degradedReason, true);
    }

    public long getDocs() {
        return this.docs;
    }

    public long getActive() {
        return this.active;
    }

    public static int toDegradation(boolean degradeByMatchPhase, boolean degradedByTimeout, boolean degradedByAdaptiveTimeout) {
        int v = 0;
        if (degradeByMatchPhase) {
            v |= 1;
        }
        if (degradedByTimeout) {
            v |= 2;
        }
        if (degradedByAdaptiveTimeout) {
            v |= 4;
        }
        return v;
    }

    public long getTargetActive() {
        return this.targetActive;
    }

    public boolean isDegraded() {
        return this.degradedReason != 0 || this.isDegradedByNonIdealState();
    }

    public boolean isDegradedByMatchPhase() {
        return (this.degradedReason & 1) != 0;
    }

    public boolean isDegradedByTimeout() {
        return (this.degradedReason & 2) != 0;
    }

    public boolean isDegradedByAdapativeTimeout() {
        return (this.degradedReason & 4) != 0;
    }

    public boolean isDegradedByNonIdealState() {
        return this.degradedReason == 0 && this.getResultPercentage() != 100;
    }

    public int getResultPercentage() {
        long total;
        long l = total = this.useTargetActiveForCoverageComputation ? this.targetActive : this.active;
        if (this.docs < total) {
            return (int)Math.round((double)this.docs * 100.0 / (double)total);
        }
        return 100;
    }
}

